/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.VirtualClusterProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class VirtualClusterUpdate
implements JsonSerializable<VirtualClusterUpdate> {
    private VirtualClusterProperties innerProperties;
    private Map<String, String> tags;

    private VirtualClusterProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VirtualClusterUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String subnetId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetId();
    }

    public String family() {
        return this.innerProperties() == null ? null : this.innerProperties().family();
    }

    public VirtualClusterUpdate withFamily(String family) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualClusterProperties();
        }
        this.innerProperties().withFamily(family);
        return this;
    }

    public List<String> childResources() {
        return this.innerProperties() == null ? null : this.innerProperties().childResources();
    }

    public String maintenanceConfigurationId() {
        return this.innerProperties() == null ? null : this.innerProperties().maintenanceConfigurationId();
    }

    public VirtualClusterUpdate withMaintenanceConfigurationId(String maintenanceConfigurationId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualClusterProperties();
        }
        this.innerProperties().withMaintenanceConfigurationId(maintenanceConfigurationId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualClusterUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualClusterUpdate)jsonReader.readObject(reader -> {
            VirtualClusterUpdate deserializedVirtualClusterUpdate = new VirtualClusterUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVirtualClusterUpdate.innerProperties = VirtualClusterProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVirtualClusterUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualClusterUpdate;
        });
    }
}

