/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class JobCredentialProperties
implements JsonSerializable<JobCredentialProperties> {
    private String username;
    private String password;
    private static final ClientLogger LOGGER = new ClientLogger(JobCredentialProperties.class);

    public String username() {
        return this.username;
    }

    public JobCredentialProperties withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public JobCredentialProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model JobCredentialProperties"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model JobCredentialProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    public static JobCredentialProperties fromJson(JsonReader jsonReader) throws IOException {
        return (JobCredentialProperties)jsonReader.readObject(reader -> {
            JobCredentialProperties deserializedJobCredentialProperties = new JobCredentialProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("username".equals(fieldName)) {
                    deserializedJobCredentialProperties.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedJobCredentialProperties.password = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedJobCredentialProperties;
        });
    }
}

