/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.QueryProperties;
import java.io.IOException;

public final class ManagedInstanceQueryInner
extends ProxyResource {
    private QueryProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private QueryProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String queryText() {
        return this.innerProperties() == null ? null : this.innerProperties().queryText();
    }

    public ManagedInstanceQueryInner withQueryText(String queryText) {
        if (this.innerProperties() == null) {
            this.innerProperties = new QueryProperties();
        }
        this.innerProperties().withQueryText(queryText);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedInstanceQueryInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedInstanceQueryInner)((Object)jsonReader.readObject(reader -> {
            ManagedInstanceQueryInner deserializedManagedInstanceQueryInner = new ManagedInstanceQueryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedInstanceQueryInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedInstanceQueryInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedInstanceQueryInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedInstanceQueryInner.innerProperties = QueryProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedInstanceQueryInner;
        }));
    }
}

