/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.fluent.models.SecurityEventProperties;
import com.azure.resourcemanager.sql.models.SecurityEventSqlInjectionAdditionalProperties;
import com.azure.resourcemanager.sql.models.SecurityEventType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class SecurityEventInner
extends ProxyResource {
    private SecurityEventProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private SecurityEventProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public OffsetDateTime eventTime() {
        return this.innerProperties() == null ? null : this.innerProperties().eventTime();
    }

    public SecurityEventType securityEventType() {
        return this.innerProperties() == null ? null : this.innerProperties().securityEventType();
    }

    public String subscription() {
        return this.innerProperties() == null ? null : this.innerProperties().subscription();
    }

    public String server() {
        return this.innerProperties() == null ? null : this.innerProperties().server();
    }

    public String database() {
        return this.innerProperties() == null ? null : this.innerProperties().database();
    }

    public String clientIp() {
        return this.innerProperties() == null ? null : this.innerProperties().clientIp();
    }

    public String applicationName() {
        return this.innerProperties() == null ? null : this.innerProperties().applicationName();
    }

    public String principalName() {
        return this.innerProperties() == null ? null : this.innerProperties().principalName();
    }

    public SecurityEventSqlInjectionAdditionalProperties securityEventSqlInjectionAdditionalProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().securityEventSqlInjectionAdditionalProperties();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SecurityEventInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityEventInner)((Object)jsonReader.readObject(reader -> {
            SecurityEventInner deserializedSecurityEventInner = new SecurityEventInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecurityEventInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecurityEventInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecurityEventInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecurityEventInner.innerProperties = SecurityEventProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityEventInner;
        }));
    }
}

