/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.sql.models.ServerKeyType;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class ServerKeyProperties
implements JsonSerializable<ServerKeyProperties> {
    private String subregion;
    private ServerKeyType serverKeyType;
    private String uri;
    private String thumbprint;
    private OffsetDateTime creationDate;
    private Boolean autoRotationEnabled;
    private static final ClientLogger LOGGER = new ClientLogger(ServerKeyProperties.class);

    public String subregion() {
        return this.subregion;
    }

    public ServerKeyType serverKeyType() {
        return this.serverKeyType;
    }

    public ServerKeyProperties withServerKeyType(ServerKeyType serverKeyType) {
        this.serverKeyType = serverKeyType;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public ServerKeyProperties withUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String thumbprint() {
        return this.thumbprint;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public Boolean autoRotationEnabled() {
        return this.autoRotationEnabled;
    }

    public void validate() {
        if (this.serverKeyType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property serverKeyType in model ServerKeyProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serverKeyType", this.serverKeyType == null ? null : this.serverKeyType.toString());
        jsonWriter.writeStringField("uri", this.uri);
        return jsonWriter.writeEndObject();
    }

    public static ServerKeyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerKeyProperties)jsonReader.readObject(reader -> {
            ServerKeyProperties deserializedServerKeyProperties = new ServerKeyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serverKeyType".equals(fieldName)) {
                    deserializedServerKeyProperties.serverKeyType = ServerKeyType.fromString(reader.getString());
                    continue;
                }
                if ("subregion".equals(fieldName)) {
                    deserializedServerKeyProperties.subregion = reader.getString();
                    continue;
                }
                if ("uri".equals(fieldName)) {
                    deserializedServerKeyProperties.uri = reader.getString();
                    continue;
                }
                if ("thumbprint".equals(fieldName)) {
                    deserializedServerKeyProperties.thumbprint = reader.getString();
                    continue;
                }
                if ("creationDate".equals(fieldName)) {
                    deserializedServerKeyProperties.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("autoRotationEnabled".equals(fieldName)) {
                    deserializedServerKeyProperties.autoRotationEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerKeyProperties;
        });
    }
}

