/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.resourcemanager.sql.fluent.models.DatabaseInner;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolImpl;
import com.azure.resourcemanager.sql.models.CreateMode;
import com.azure.resourcemanager.sql.models.RestorePoint;
import com.azure.resourcemanager.sql.models.SampleName;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlElasticPoolOperations;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SqlDatabaseForElasticPoolImpl
implements SqlDatabase.DefinitionStages.WithExistingDatabaseAfterElasticPool<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithStorageKeyAfterElasticPool<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithAuthenticationAfterElasticPool<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithCreateMode<SqlElasticPoolOperations.DefinitionStages.WithCreate>,
SqlDatabase.DefinitionStages.WithAttachAfterElasticPoolOptions<SqlElasticPoolOperations.DefinitionStages.WithCreate> {
    private SqlDatabaseImpl sqlDatabase;
    private SqlElasticPoolImpl sqlElasticPool;

    SqlDatabaseForElasticPoolImpl(SqlElasticPoolImpl sqlElasticPool, SqlDatabaseImpl sqlDatabase) {
        Objects.requireNonNull(sqlElasticPool);
        Objects.requireNonNull(sqlDatabase);
        Objects.requireNonNull((DatabaseInner)((Object)sqlDatabase.innerModel()));
        this.sqlElasticPool = sqlElasticPool;
        this.sqlDatabase = sqlDatabase;
        ((DatabaseInner)((Object)this.sqlDatabase.innerModel())).withLocation(sqlElasticPool.regionName());
        ((DatabaseInner)((Object)this.sqlDatabase.innerModel())).withElasticPoolId(this.sqlElasticPool.id());
        ((DatabaseInner)((Object)this.sqlDatabase.innerModel())).withSku(null);
    }

    public SqlElasticPoolImpl attach() {
        return this.sqlElasticPool;
    }

    public SqlDatabaseForElasticPoolImpl withSourceDatabase(String sourceDatabaseId) {
        ((DatabaseInner)((Object)this.sqlDatabase.innerModel())).withSourceDatabaseId(sourceDatabaseId);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withSourceDatabase(SqlDatabase sourceDatabase) {
        ((DatabaseInner)((Object)this.sqlDatabase.innerModel())).withSourceDatabaseId(sourceDatabase.databaseId());
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withMode(CreateMode createMode) {
        this.sqlDatabase.withMode(createMode);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withCollation(String collation) {
        this.sqlDatabase.withCollation(collation);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withMaxSizeBytes(long maxSizeBytes) {
        this.sqlDatabase.withMaxSizeBytes(maxSizeBytes);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl importFrom(String storageUri) {
        this.sqlDatabase.importFrom(storageUri);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl importFrom(StorageAccount storageAccount, String containerName, String fileName) {
        this.sqlDatabase.importFrom(storageAccount, containerName, fileName);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withStorageAccessKey(String storageAccessKey) {
        this.sqlDatabase.withStorageAccessKey(storageAccessKey);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withSharedAccessKey(String sharedAccessKey) {
        this.sqlDatabase.withSharedAccessKey(sharedAccessKey);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withSqlAdministratorLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.sqlDatabase.withSqlAdministratorLoginAndPassword(administratorLogin, administratorPassword);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl withActiveDirectoryLoginAndPassword(String administratorLogin, String administratorPassword) {
        this.sqlDatabase.withActiveDirectoryLoginAndPassword(administratorLogin, administratorPassword);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl fromRestorePoint(RestorePoint restorePoint) {
        this.sqlDatabase.fromRestorePoint(restorePoint);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl fromRestorePoint(RestorePoint restorePoint, OffsetDateTime restorePointDateTime) {
        this.sqlDatabase.fromRestorePoint(restorePoint, restorePointDateTime);
        return this;
    }

    public SqlDatabaseForElasticPoolImpl fromSample(SampleName sampleName) {
        this.sqlDatabase.fromSample(sampleName);
        return this;
    }
}

