/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.collection.SupportsCreating;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.sql.models.ElasticPoolSku;
import com.azure.resourcemanager.sql.models.Sku;
import com.azure.resourcemanager.sql.models.SqlChildrenOperations;
import com.azure.resourcemanager.sql.models.SqlDatabase;
import com.azure.resourcemanager.sql.models.SqlElasticPool;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolBasicMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolPremiumSorage;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardMaxEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardMinEDTUs;
import com.azure.resourcemanager.sql.models.SqlElasticPoolStandardStorage;
import com.azure.resourcemanager.sql.models.SqlServer;

public interface SqlElasticPoolOperations
extends SupportsCreating<DefinitionStages.WithSqlServer>,
SqlChildrenOperations<SqlElasticPool> {

    public static interface SqlElasticPoolActionsDefinition
    extends SqlChildrenOperations.SqlChildrenActionsDefinition<SqlElasticPool> {
        public DefinitionStages.WithEdition define(String var1);
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends WithDatabaseMinCapacity,
        WithDatabaseMaxCapacity,
        WithStorageCapacity,
        WithDatabase,
        Resource.DefinitionWithTags<WithCreate>,
        Creatable<SqlElasticPool> {
        }

        public static interface WithDatabase {
            public WithCreate withNewDatabase(String var1);

            public WithCreate withExistingDatabase(String var1);

            public WithCreate withExistingDatabase(SqlDatabase var1);

            public SqlDatabase.DefinitionStages.WithExistingDatabaseAfterElasticPool<WithCreate> defineDatabase(String var1);
        }

        public static interface WithStorageCapacity {
            public WithCreate withStorageCapacity(Long var1);
        }

        public static interface WithDatabaseMaxCapacity {
            public WithCreate withDatabaseMaxCapacity(double var1);
        }

        public static interface WithDatabaseMinCapacity {
            public WithCreate withDatabaseMinCapacity(double var1);
        }

        public static interface WithPremiumEdition
        extends WithCreate {
            public WithPremiumEdition withReservedDtu(SqlElasticPoolPremiumEDTUs var1);

            public WithPremiumEdition withDatabaseDtuMax(SqlElasticPoolPremiumMaxEDTUs var1);

            public WithPremiumEdition withDatabaseDtuMin(SqlElasticPoolPremiumMinEDTUs var1);

            public WithPremiumEdition withStorageCapacity(SqlElasticPoolPremiumSorage var1);
        }

        public static interface WithStandardEdition
        extends WithCreate {
            public WithStandardEdition withReservedDtu(SqlElasticPoolStandardEDTUs var1);

            public WithStandardEdition withDatabaseDtuMax(SqlElasticPoolStandardMaxEDTUs var1);

            public WithStandardEdition withDatabaseDtuMin(SqlElasticPoolStandardMinEDTUs var1);

            public WithStandardEdition withStorageCapacity(SqlElasticPoolStandardStorage var1);
        }

        public static interface WithBasicEdition
        extends WithCreate {
            public WithBasicEdition withReservedDtu(SqlElasticPoolBasicEDTUs var1);

            public WithBasicEdition withDatabaseDtuMax(SqlElasticPoolBasicMaxEDTUs var1);

            public WithBasicEdition withDatabaseDtuMin(SqlElasticPoolBasicMinEDTUs var1);
        }

        public static interface WithEdition {
            public WithCreate withSku(ElasticPoolSku var1);

            public WithCreate withSku(Sku var1);

            public WithBasicEdition withBasicPool();

            public WithStandardEdition withStandardPool();

            public WithPremiumEdition withPremiumPool();
        }

        public static interface WithSqlServer {
            public WithEdition withExistingSqlServer(String var1, String var2, String var3);

            public WithEdition withExistingSqlServer(SqlServer var1);
        }
    }

    public static interface SqlElasticPoolOperationsDefinition
    extends DefinitionStages.WithSqlServer,
    DefinitionStages.WithEdition,
    DefinitionStages.WithBasicEdition,
    DefinitionStages.WithStandardEdition,
    DefinitionStages.WithPremiumEdition {
    }
}

