/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.storage.fluent.models.BlobRestoreStatusInner;
import com.azure.resourcemanager.storage.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountPropertiesInner;
import com.azure.resourcemanager.storage.models.AccessTier;
import com.azure.resourcemanager.storage.models.AccountStatus;
import com.azure.resourcemanager.storage.models.AllowedCopyScope;
import com.azure.resourcemanager.storage.models.AzureFilesIdentityBasedAuthentication;
import com.azure.resourcemanager.storage.models.CustomDomain;
import com.azure.resourcemanager.storage.models.DnsEndpointType;
import com.azure.resourcemanager.storage.models.Encryption;
import com.azure.resourcemanager.storage.models.Endpoints;
import com.azure.resourcemanager.storage.models.ExtendedLocation;
import com.azure.resourcemanager.storage.models.GeoReplicationStats;
import com.azure.resourcemanager.storage.models.Identity;
import com.azure.resourcemanager.storage.models.ImmutableStorageAccount;
import com.azure.resourcemanager.storage.models.KeyCreationTime;
import com.azure.resourcemanager.storage.models.KeyPolicy;
import com.azure.resourcemanager.storage.models.Kind;
import com.azure.resourcemanager.storage.models.LargeFileSharesState;
import com.azure.resourcemanager.storage.models.MinimumTlsVersion;
import com.azure.resourcemanager.storage.models.NetworkRuleSet;
import com.azure.resourcemanager.storage.models.ProvisioningState;
import com.azure.resourcemanager.storage.models.PublicNetworkAccess;
import com.azure.resourcemanager.storage.models.RoutingPreference;
import com.azure.resourcemanager.storage.models.SasPolicy;
import com.azure.resourcemanager.storage.models.Sku;
import com.azure.resourcemanager.storage.models.StorageAccountSkuConversionStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class StorageAccountInner
extends Resource {
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku sku;
    @JsonProperty(value="kind", access=JsonProperty.Access.WRITE_ONLY)
    private Kind kind;
    @JsonProperty(value="identity")
    private Identity identity;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties")
    private StorageAccountPropertiesInner innerProperties;

    public Sku sku() {
        return this.sku;
    }

    public Kind kind() {
        return this.kind;
    }

    public Identity identity() {
        return this.identity;
    }

    public StorageAccountInner withIdentity(Identity identity) {
        this.identity = identity;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public StorageAccountInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private StorageAccountPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public StorageAccountInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public StorageAccountInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Endpoints primaryEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryEndpoints();
    }

    public String primaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().primaryLocation();
    }

    public AccountStatus statusOfPrimary() {
        return this.innerProperties() == null ? null : this.innerProperties().statusOfPrimary();
    }

    public OffsetDateTime lastGeoFailoverTime() {
        return this.innerProperties() == null ? null : this.innerProperties().lastGeoFailoverTime();
    }

    public String secondaryLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryLocation();
    }

    public AccountStatus statusOfSecondary() {
        return this.innerProperties() == null ? null : this.innerProperties().statusOfSecondary();
    }

    public OffsetDateTime creationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().creationTime();
    }

    public CustomDomain customDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().customDomain();
    }

    public SasPolicy sasPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().sasPolicy();
    }

    public KeyPolicy keyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().keyPolicy();
    }

    public KeyCreationTime keyCreationTime() {
        return this.innerProperties() == null ? null : this.innerProperties().keyCreationTime();
    }

    public Endpoints secondaryEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().secondaryEndpoints();
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public AccessTier accessTier() {
        return this.innerProperties() == null ? null : this.innerProperties().accessTier();
    }

    public AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().azureFilesIdentityBasedAuthentication();
    }

    public StorageAccountInner withAzureFilesIdentityBasedAuthentication(AzureFilesIdentityBasedAuthentication azureFilesIdentityBasedAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withAzureFilesIdentityBasedAuthentication(azureFilesIdentityBasedAuthentication);
        return this;
    }

    public Boolean enableHttpsTrafficOnly() {
        return this.innerProperties() == null ? null : this.innerProperties().enableHttpsTrafficOnly();
    }

    public StorageAccountInner withEnableHttpsTrafficOnly(Boolean enableHttpsTrafficOnly) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withEnableHttpsTrafficOnly(enableHttpsTrafficOnly);
        return this;
    }

    public NetworkRuleSet networkRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().networkRuleSet();
    }

    public Boolean isSftpEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isSftpEnabled();
    }

    public StorageAccountInner withIsSftpEnabled(Boolean isSftpEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withIsSftpEnabled(isSftpEnabled);
        return this;
    }

    public Boolean isLocalUserEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isLocalUserEnabled();
    }

    public StorageAccountInner withIsLocalUserEnabled(Boolean isLocalUserEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withIsLocalUserEnabled(isLocalUserEnabled);
        return this;
    }

    public Boolean enableExtendedGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().enableExtendedGroups();
    }

    public StorageAccountInner withEnableExtendedGroups(Boolean enableExtendedGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withEnableExtendedGroups(enableExtendedGroups);
        return this;
    }

    public Boolean isHnsEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isHnsEnabled();
    }

    public StorageAccountInner withIsHnsEnabled(Boolean isHnsEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withIsHnsEnabled(isHnsEnabled);
        return this;
    }

    public GeoReplicationStats geoReplicationStats() {
        return this.innerProperties() == null ? null : this.innerProperties().geoReplicationStats();
    }

    public Boolean failoverInProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().failoverInProgress();
    }

    public LargeFileSharesState largeFileSharesState() {
        return this.innerProperties() == null ? null : this.innerProperties().largeFileSharesState();
    }

    public StorageAccountInner withLargeFileSharesState(LargeFileSharesState largeFileSharesState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withLargeFileSharesState(largeFileSharesState);
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public RoutingPreference routingPreference() {
        return this.innerProperties() == null ? null : this.innerProperties().routingPreference();
    }

    public StorageAccountInner withRoutingPreference(RoutingPreference routingPreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withRoutingPreference(routingPreference);
        return this;
    }

    public BlobRestoreStatusInner blobRestoreStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().blobRestoreStatus();
    }

    public Boolean allowBlobPublicAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().allowBlobPublicAccess();
    }

    public StorageAccountInner withAllowBlobPublicAccess(Boolean allowBlobPublicAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withAllowBlobPublicAccess(allowBlobPublicAccess);
        return this;
    }

    public MinimumTlsVersion minimumTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimumTlsVersion();
    }

    public StorageAccountInner withMinimumTlsVersion(MinimumTlsVersion minimumTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withMinimumTlsVersion(minimumTlsVersion);
        return this;
    }

    public Boolean allowSharedKeyAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().allowSharedKeyAccess();
    }

    public StorageAccountInner withAllowSharedKeyAccess(Boolean allowSharedKeyAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withAllowSharedKeyAccess(allowSharedKeyAccess);
        return this;
    }

    public Boolean enableNfsV3() {
        return this.innerProperties() == null ? null : this.innerProperties().enableNfsV3();
    }

    public StorageAccountInner withEnableNfsV3(Boolean enableNfsV3) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withEnableNfsV3(enableNfsV3);
        return this;
    }

    public Boolean allowCrossTenantReplication() {
        return this.innerProperties() == null ? null : this.innerProperties().allowCrossTenantReplication();
    }

    public StorageAccountInner withAllowCrossTenantReplication(Boolean allowCrossTenantReplication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withAllowCrossTenantReplication(allowCrossTenantReplication);
        return this;
    }

    public Boolean defaultToOAuthAuthentication() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultToOAuthAuthentication();
    }

    public StorageAccountInner withDefaultToOAuthAuthentication(Boolean defaultToOAuthAuthentication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withDefaultToOAuthAuthentication(defaultToOAuthAuthentication);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public StorageAccountInner withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public ImmutableStorageAccount immutableStorageWithVersioning() {
        return this.innerProperties() == null ? null : this.innerProperties().immutableStorageWithVersioning();
    }

    public StorageAccountInner withImmutableStorageWithVersioning(ImmutableStorageAccount immutableStorageWithVersioning) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withImmutableStorageWithVersioning(immutableStorageWithVersioning);
        return this;
    }

    public AllowedCopyScope allowedCopyScope() {
        return this.innerProperties() == null ? null : this.innerProperties().allowedCopyScope();
    }

    public StorageAccountInner withAllowedCopyScope(AllowedCopyScope allowedCopyScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withAllowedCopyScope(allowedCopyScope);
        return this;
    }

    public StorageAccountSkuConversionStatus storageAccountSkuConversionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountSkuConversionStatus();
    }

    public StorageAccountInner withStorageAccountSkuConversionStatus(StorageAccountSkuConversionStatus storageAccountSkuConversionStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withStorageAccountSkuConversionStatus(storageAccountSkuConversionStatus);
        return this;
    }

    public DnsEndpointType dnsEndpointType() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsEndpointType();
    }

    public StorageAccountInner withDnsEndpointType(DnsEndpointType dnsEndpointType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StorageAccountPropertiesInner();
        }
        this.innerProperties().withDnsEndpointType(dnsEndpointType);
        return this;
    }

    public Boolean isSkuConversionBlocked() {
        return this.innerProperties() == null ? null : this.innerProperties().isSkuConversionBlocked();
    }

    public Boolean accountMigrationInProgress() {
        return this.innerProperties() == null ? null : this.innerProperties().accountMigrationInProgress();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

