/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.azure.resourcemanager.storage.models.SignedIdentifier;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FileShareProperties
implements JsonSerializable<FileShareProperties> {
    private OffsetDateTime lastModifiedTime;
    private Map<String, String> metadata;
    private Integer shareQuota;
    private EnabledProtocols enabledProtocols;
    private RootSquashType rootSquash;
    private String version;
    private Boolean deleted;
    private OffsetDateTime deletedTime;
    private Integer remainingRetentionDays;
    private ShareAccessTier accessTier;
    private OffsetDateTime accessTierChangeTime;
    private String accessTierStatus;
    private Long shareUsageBytes;
    private LeaseStatus leaseStatus;
    private LeaseState leaseState;
    private LeaseDuration leaseDuration;
    private List<SignedIdentifier> signedIdentifiers;
    private OffsetDateTime snapshotTime;

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public FileShareProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer shareQuota() {
        return this.shareQuota;
    }

    public FileShareProperties withShareQuota(Integer shareQuota) {
        this.shareQuota = shareQuota;
        return this;
    }

    public EnabledProtocols enabledProtocols() {
        return this.enabledProtocols;
    }

    public FileShareProperties withEnabledProtocols(EnabledProtocols enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public RootSquashType rootSquash() {
        return this.rootSquash;
    }

    public FileShareProperties withRootSquash(RootSquashType rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareAccessTier accessTier() {
        return this.accessTier;
    }

    public FileShareProperties withAccessTier(ShareAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public String accessTierStatus() {
        return this.accessTierStatus;
    }

    public Long shareUsageBytes() {
        return this.shareUsageBytes;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public List<SignedIdentifier> signedIdentifiers() {
        return this.signedIdentifiers;
    }

    public FileShareProperties withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    public OffsetDateTime snapshotTime() {
        return this.snapshotTime;
    }

    public void validate() {
        if (this.signedIdentifiers() != null) {
            this.signedIdentifiers().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("shareQuota", (Number)this.shareQuota);
        jsonWriter.writeStringField("enabledProtocols", this.enabledProtocols == null ? null : this.enabledProtocols.toString());
        jsonWriter.writeStringField("rootSquash", this.rootSquash == null ? null : this.rootSquash.toString());
        jsonWriter.writeStringField("accessTier", this.accessTier == null ? null : this.accessTier.toString());
        jsonWriter.writeArrayField("signedIdentifiers", this.signedIdentifiers, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static FileShareProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FileShareProperties)jsonReader.readObject(reader -> {
            FileShareProperties deserializedFileShareProperties = new FileShareProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastModifiedTime".equals(fieldName)) {
                    deserializedFileShareProperties.lastModifiedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    Map metadata;
                    deserializedFileShareProperties.metadata = metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("shareQuota".equals(fieldName)) {
                    deserializedFileShareProperties.shareQuota = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("enabledProtocols".equals(fieldName)) {
                    deserializedFileShareProperties.enabledProtocols = EnabledProtocols.fromString(reader.getString());
                    continue;
                }
                if ("rootSquash".equals(fieldName)) {
                    deserializedFileShareProperties.rootSquash = RootSquashType.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedFileShareProperties.version = reader.getString();
                    continue;
                }
                if ("deleted".equals(fieldName)) {
                    deserializedFileShareProperties.deleted = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("deletedTime".equals(fieldName)) {
                    deserializedFileShareProperties.deletedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("remainingRetentionDays".equals(fieldName)) {
                    deserializedFileShareProperties.remainingRetentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("accessTier".equals(fieldName)) {
                    deserializedFileShareProperties.accessTier = ShareAccessTier.fromString(reader.getString());
                    continue;
                }
                if ("accessTierChangeTime".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierChangeTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("accessTierStatus".equals(fieldName)) {
                    deserializedFileShareProperties.accessTierStatus = reader.getString();
                    continue;
                }
                if ("shareUsageBytes".equals(fieldName)) {
                    deserializedFileShareProperties.shareUsageBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("leaseStatus".equals(fieldName)) {
                    deserializedFileShareProperties.leaseStatus = LeaseStatus.fromString(reader.getString());
                    continue;
                }
                if ("leaseState".equals(fieldName)) {
                    deserializedFileShareProperties.leaseState = LeaseState.fromString(reader.getString());
                    continue;
                }
                if ("leaseDuration".equals(fieldName)) {
                    deserializedFileShareProperties.leaseDuration = LeaseDuration.fromString(reader.getString());
                    continue;
                }
                if ("signedIdentifiers".equals(fieldName)) {
                    List signedIdentifiers;
                    deserializedFileShareProperties.signedIdentifiers = signedIdentifiers = reader.readArray(reader1 -> SignedIdentifier.fromJson(reader1));
                    continue;
                }
                if ("snapshotTime".equals(fieldName)) {
                    deserializedFileShareProperties.snapshotTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFileShareProperties;
        });
    }
}

