/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.StorageTaskAssignmentProperties;
import java.io.IOException;

public final class StorageTaskAssignmentInner
extends ProxyResource {
    private StorageTaskAssignmentProperties properties;
    private String id;
    private String name;
    private String type;
    private static final ClientLogger LOGGER = new ClientLogger(StorageTaskAssignmentInner.class);

    public StorageTaskAssignmentProperties properties() {
        return this.properties;
    }

    public StorageTaskAssignmentInner withProperties(StorageTaskAssignmentProperties properties) {
        this.properties = properties;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model StorageTaskAssignmentInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskAssignmentInner fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskAssignmentInner)((Object)jsonReader.readObject(reader -> {
            StorageTaskAssignmentInner deserializedStorageTaskAssignmentInner = new StorageTaskAssignmentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedStorageTaskAssignmentInner.properties = StorageTaskAssignmentProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskAssignmentInner;
        }));
    }
}

