/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ReasonCode;
import java.io.IOException;
import java.util.List;

public final class Restriction
implements JsonSerializable<Restriction> {
    private String type;
    private List<String> values;
    private ReasonCode reasonCode;

    public String type() {
        return this.type;
    }

    public List<String> values() {
        return this.values;
    }

    public ReasonCode reasonCode() {
        return this.reasonCode;
    }

    public Restriction withReasonCode(ReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("reasonCode", this.reasonCode == null ? null : this.reasonCode.toString());
        return jsonWriter.writeEndObject();
    }

    public static Restriction fromJson(JsonReader jsonReader) throws IOException {
        return (Restriction)jsonReader.readObject(reader -> {
            Restriction deserializedRestriction = new Restriction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedRestriction.type = reader.getString();
                    continue;
                }
                if ("values".equals(fieldName)) {
                    List values;
                    deserializedRestriction.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("reasonCode".equals(fieldName)) {
                    deserializedRestriction.reasonCode = ReasonCode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestriction;
        });
    }
}

