/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt;

import com.b3dgs.lionengine.awt.EventAction;
import com.b3dgs.lionengine.awt.Keyboard;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class KeyboardAwt
implements Keyboard,
KeyListener {
    public static final Integer ENTER = 10;
    public static final Integer TAB = 9;
    public static final Integer BACK_SPACE = 8;
    public static final Integer SPACE = 32;
    public static final Integer ESCAPE = 27;
    public static final Integer ALT = 18;
    public static final Integer CONTROL = 17;
    public static final Integer LEFT = 37;
    public static final Integer RIGHT = 39;
    public static final Integer DOWN = 40;
    public static final Integer UP = 38;
    public static final Integer NO_KEY_CODE = -1;
    private static final char EMPTY_KEY_NAME = ' ';
    private final Map<Integer, List<EventAction>> actionsPressed = new HashMap<Integer, List<EventAction>>();
    private final Map<Integer, List<EventAction>> actionsReleased = new HashMap<Integer, List<EventAction>>();
    private final Collection<Integer> keys = new HashSet<Integer>();
    private final Collection<Integer> pressed = new HashSet<Integer>();
    private Integer lastCode = NO_KEY_CODE;
    private char lastKeyName = (char)32;
    private Integer leftKey = LEFT;
    private Integer rightKey = RIGHT;
    private Integer upKey = UP;
    private Integer downKey = DOWN;

    @Override
    public void addActionPressed(Integer key, EventAction action) {
        List<Object> list;
        if (this.actionsPressed.get(key) == null) {
            list = new ArrayList();
            this.actionsPressed.put(key, list);
        } else {
            list = this.actionsPressed.get(key);
        }
        list.add(action);
    }

    @Override
    public void addActionReleased(Integer key, EventAction action) {
        List<Object> list;
        if (this.actionsReleased.get(key) == null) {
            list = new ArrayList();
            this.actionsReleased.put(key, list);
        } else {
            list = this.actionsReleased.get(key);
        }
        list.add(action);
    }

    @Override
    public void removeActionsPressed() {
        this.actionsPressed.clear();
    }

    @Override
    public void removeActionsReleased() {
        this.actionsReleased.clear();
    }

    @Override
    public boolean isPressed(Integer key) {
        return this.keys.contains(key);
    }

    @Override
    public boolean isPressedOnce(Integer key) {
        if (this.keys.contains(key) && !this.pressed.contains(key)) {
            this.pressed.add(key);
            return true;
        }
        return false;
    }

    @Override
    public Integer getKeyCode() {
        return this.lastCode;
    }

    @Override
    public char getKeyName() {
        return this.lastKeyName;
    }

    @Override
    public boolean used() {
        return !this.keys.isEmpty();
    }

    public void setHorizontalControlPositive(Integer code) {
        this.rightKey = code;
    }

    public void setHorizontalControlNegative(Integer code) {
        this.leftKey = code;
    }

    public void setVerticalControlPositive(Integer code) {
        this.upKey = code;
    }

    public void setVerticalControlNegative(Integer code) {
        this.downKey = code;
    }

    public Integer getHorizontalControlPositive() {
        return this.rightKey;
    }

    public Integer getHorizontalControlNegative() {
        return this.leftKey;
    }

    public Integer getVerticalControlPositive() {
        return this.upKey;
    }

    public Integer getVerticalControlNegative() {
        return this.downKey;
    }

    public double getHorizontalDirection() {
        double direction = this.isPressed(this.leftKey) ? -1.0 : (this.isPressed(this.rightKey) ? 1.0 : 0.0);
        return direction;
    }

    public double getVerticalDirection() {
        int direction = this.isPressed(this.downKey) ? -1 : (this.isPressed(this.upKey) ? 1 : 0);
        return direction;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.lastKeyName = event.getKeyChar();
        this.lastCode = event.getKeyCode();
        if (!this.keys.contains(this.lastCode)) {
            this.keys.add(this.lastCode);
        }
        if (this.actionsPressed.containsKey(this.lastCode)) {
            List<EventAction> actions = this.actionsPressed.get(this.lastCode);
            for (EventAction current : actions) {
                current.action();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.lastKeyName = (char)32;
        this.lastCode = NO_KEY_CODE;
        Integer key = event.getKeyCode();
        this.keys.remove(key);
        this.pressed.remove(key);
        if (this.actionsReleased.containsKey(key)) {
            List<EventAction> actions = this.actionsReleased.get(key);
            for (EventAction current : actions) {
                current.action();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }
}

