/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt;

import com.b3dgs.lionengine.awt.Keyboard;
import com.b3dgs.lionengine.io.InputDeviceControl;
import java.util.HashMap;
import java.util.Map;

public final class KeyboardController
implements InputDeviceControl {
    private final Keyboard keyboard;
    private final Map<Integer, Integer> fire = new HashMap<Integer, Integer>();

    public KeyboardController(Keyboard keyboard) {
        this.keyboard = keyboard;
    }

    public void setHorizontalControlPositive(Integer code) {
        this.keyboard.setHorizontalControlPositive(code);
    }

    public void setHorizontalControlNegative(Integer code) {
        this.keyboard.setHorizontalControlNegative(code);
    }

    public void setVerticalControlPositive(Integer code) {
        this.keyboard.setVerticalControlPositive(code);
    }

    public void setVerticalControlNegative(Integer code) {
        this.keyboard.setVerticalControlNegative(code);
    }

    public Integer getHorizontalControlPositive() {
        return this.keyboard.getHorizontalControlPositive();
    }

    public Integer getHorizontalControlNegative() {
        return this.keyboard.getHorizontalControlNegative();
    }

    public Integer getVerticalControlPositive() {
        return this.keyboard.getVerticalControlPositive();
    }

    public Integer getVerticalControlNegative() {
        return this.keyboard.getVerticalControlNegative();
    }

    public double getHorizontalDirection() {
        return this.keyboard.getHorizontalDirection();
    }

    public double getVerticalDirection() {
        return this.keyboard.getVerticalDirection();
    }

    public void setFireButton(Integer index, Integer code) {
        this.fire.put(index, code);
    }

    public boolean isUpButtonOnce() {
        return this.keyboard.isPressedOnce(this.keyboard.getVerticalControlPositive());
    }

    public boolean isDownButtonOnce() {
        return this.keyboard.isPressedOnce(this.keyboard.getVerticalControlNegative());
    }

    public boolean isLeftButtonOnce() {
        return this.keyboard.isPressedOnce(this.keyboard.getHorizontalControlNegative());
    }

    public boolean isRightButtonOnce() {
        return this.keyboard.isPressedOnce(this.keyboard.getHorizontalControlPositive());
    }

    public boolean isFireButton(Integer index) {
        Integer code = this.fire.get(index);
        if (code != null) {
            return this.keyboard.isPressed(code);
        }
        return false;
    }

    public boolean isFireButtonOnce(Integer index) {
        Integer code = this.fire.get(index);
        if (code != null) {
            return this.keyboard.isPressedOnce(code);
        }
        return false;
    }
}

