/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.Resolution;
import com.b3dgs.lionengine.Verbose;
import com.b3dgs.lionengine.awt.EventAction;
import com.b3dgs.lionengine.awt.Mouse;
import com.b3dgs.lionengine.awt.MouseClickAwt;
import com.b3dgs.lionengine.awt.MouseMoveAwt;
import java.awt.AWTException;
import java.awt.Robot;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public final class MouseAwt
implements Mouse {
    public static final int LEFT = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT = 3;
    private static final String ERROR_ROBOT = "No mouse robot available !";
    private final MouseClickAwt clicker = new MouseClickAwt();
    private final MouseMoveAwt mover = new MouseMoveAwt();
    private final Robot robot = MouseAwt.createRobot();
    private double xRatio;
    private double yRatio;
    private int release = -1;
    private boolean doRelease;

    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[]{ERROR_ROBOT});
            return null;
        }
    }

    public void setResolution(Resolution output, Resolution source) {
        Check.notNull((Object)output);
        Check.notNull((Object)source);
        this.xRatio = (double)output.getWidth() / (double)source.getWidth();
        this.yRatio = (double)output.getHeight() / (double)source.getHeight();
    }

    public MouseListener getClicker() {
        return this.clicker;
    }

    public MouseMotionListener getMover() {
        return this.mover;
    }

    @Override
    public void addActionPressed(int click, EventAction action) {
        this.clicker.addActionPressed(click, action);
    }

    @Override
    public void addActionReleased(int click, EventAction action) {
        this.clicker.addActionReleased(click, action);
    }

    @Override
    public void lock() {
        this.lock(this.mover.getCx(), this.mover.getCy());
    }

    @Override
    public void lock(int x, int y) {
        if (this.robot != null) {
            this.robot.mouseMove(x, y);
        } else {
            this.mover.robotMove(x, y);
        }
        this.mover.lock();
    }

    @Override
    public void doClick(int click) {
        this.clicker.robotPress(click);
        this.release = click;
    }

    @Override
    public void doSetMouse(int x, int y) {
        this.mover.robotTeleport(x, y);
    }

    @Override
    public void doMoveMouse(int x, int y) {
        this.mover.robotMove(x, y);
    }

    @Override
    public void doClickAt(int click, int x, int y) {
        this.mover.robotTeleport(x, y);
        this.clicker.robotPress(click);
        this.release = click;
    }

    @Override
    public void setCenter(int x, int y) {
        this.mover.setCenter(x, y);
    }

    @Override
    public int getOnScreenX() {
        return this.mover.getX();
    }

    @Override
    public int getOnScreenY() {
        return this.mover.getY();
    }

    public int getX() {
        return (int)((double)this.mover.getWx() / this.xRatio);
    }

    public int getY() {
        return (int)((double)this.mover.getWy() / this.yRatio);
    }

    public int getMoveX() {
        return this.mover.getMx();
    }

    public int getMoveY() {
        return this.mover.getMy();
    }

    public int getClick() {
        return this.clicker.getClick();
    }

    public boolean hasClicked(int click) {
        return this.clicker.hasClicked(click);
    }

    public boolean hasClickedOnce(int click) {
        return this.clicker.hasClickedOnce(click);
    }

    public boolean hasMoved() {
        return this.mover.hasMoved();
    }

    public void update(double extrp) {
        this.mover.update();
        if (this.release > -1 && !this.doRelease) {
            this.doRelease = true;
        } else if (this.doRelease) {
            this.clicker.robotRelease(this.release);
            this.release = -1;
            this.doRelease = false;
        }
    }
}

