/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt;

import com.b3dgs.lionengine.Verbose;
import com.b3dgs.lionengine.awt.EventAction;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class MouseClickAwt
implements MouseListener {
    private static final int DEFAULT_BUTTONS = 3;
    private final Map<Integer, List<EventAction>> actionsPressed = new HashMap<Integer, List<EventAction>>();
    private final Map<Integer, List<EventAction>> actionsReleased = new HashMap<Integer, List<EventAction>>();
    private final boolean[] clicks;
    private final boolean[] clicked;
    private int lastClick;

    private static int getButtonsNumber() {
        try {
            return Math.max(0, MouseInfo.getNumberOfButtons()) + 1;
        }
        catch (HeadlessException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[0]);
            return 3;
        }
    }

    MouseClickAwt() {
        int mouseButtons = MouseClickAwt.getButtonsNumber();
        this.clicks = new boolean[mouseButtons];
        this.clicked = new boolean[mouseButtons];
    }

    void robotPress(int click) {
        this.lastClick = click;
        if (this.lastClick < this.clicks.length) {
            this.clicks[this.lastClick] = true;
        }
    }

    void robotRelease(int click) {
        this.lastClick = 0;
        int button = click;
        if (button < this.clicks.length) {
            this.clicks[button] = false;
            this.clicked[button] = false;
        }
    }

    void addActionPressed(int click, EventAction action) {
        List<Object> list;
        Integer key = click;
        if (this.actionsPressed.get(key) == null) {
            list = new ArrayList();
            this.actionsPressed.put(key, list);
        } else {
            list = this.actionsPressed.get(key);
        }
        list.add(action);
    }

    void addActionReleased(int click, EventAction action) {
        List<Object> list;
        Integer key = click;
        if (this.actionsReleased.get(key) == null) {
            list = new ArrayList();
            this.actionsReleased.put(key, list);
        } else {
            list = this.actionsReleased.get(key);
        }
        list.add(action);
    }

    int getClick() {
        return this.lastClick;
    }

    boolean hasClicked(int click) {
        if (click < this.clicks.length) {
            return this.clicks[click];
        }
        return false;
    }

    boolean hasClickedOnce(int click) {
        if (click < this.clicks.length && this.clicks[click] && !this.clicked[click]) {
            this.clicked[click] = true;
            return true;
        }
        return false;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.lastClick = event.getButton();
        this.clicks[this.lastClick] = true;
        Integer key = this.lastClick;
        if (this.actionsPressed.containsKey(key)) {
            List<EventAction> actions = this.actionsPressed.get(key);
            for (EventAction current : actions) {
                current.action();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        Integer key = this.lastClick;
        this.lastClick = 0;
        int button = event.getButton();
        this.clicks[button] = false;
        this.clicked[button] = false;
        if (this.actionsReleased.containsKey(key)) {
            List<EventAction> actions = this.actionsReleased.get(key);
            for (EventAction current : actions) {
                current.action();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }
}

