/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt;

import com.b3dgs.lionengine.Verbose;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

final class MouseMoveAwt
implements MouseMotionListener {
    private int x;
    private int y;
    private int wx;
    private int wy;
    private int mx;
    private int my;
    private int oldX;
    private int oldY;
    private int centerX;
    private int centerY;
    private boolean moved;

    private static com.b3dgs.lionengine.geom.Point getCursorLocation() {
        try {
            PointerInfo a = MouseInfo.getPointerInfo();
            Point b = a.getLocation();
            return new com.b3dgs.lionengine.geom.Point((int)b.getX(), (int)b.getY());
        }
        catch (HeadlessException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[0]);
            return new com.b3dgs.lionengine.geom.Point();
        }
    }

    MouseMoveAwt() {
        com.b3dgs.lionengine.geom.Point point = MouseMoveAwt.getCursorLocation();
        this.x = point.getX();
        this.y = point.getY();
        this.centerX = this.x;
        this.centerY = this.y;
        this.oldX = this.x;
        this.oldY = this.y;
    }

    void robotMove(int nx, int ny) {
        this.oldX = this.x;
        this.oldY = this.y;
        this.x = nx;
        this.y = ny;
        this.wx = nx;
        this.wy = ny;
        this.mx = this.x - this.oldX;
        this.my = this.y - this.oldY;
        this.moved = true;
    }

    void robotTeleport(int nx, int ny) {
        this.oldX = nx;
        this.oldY = ny;
        this.x = nx;
        this.y = ny;
        this.wx = nx;
        this.wy = ny;
        this.mx = 0;
        this.my = 0;
        this.moved = false;
    }

    void setCenter(int x, int y) {
        this.centerX = x;
        this.centerY = y;
    }

    void lock() {
        this.x = this.centerX;
        this.y = this.centerY;
        this.oldX = this.centerX;
        this.oldY = this.centerY;
    }

    void update() {
        this.mx = this.x - this.oldX;
        this.my = this.y - this.oldY;
        this.oldX = this.x;
        this.oldY = this.y;
    }

    int getX() {
        return this.x;
    }

    int getY() {
        return this.y;
    }

    int getWx() {
        return this.wx;
    }

    int getWy() {
        return this.wy;
    }

    int getMx() {
        return this.mx;
    }

    int getMy() {
        return this.my;
    }

    int getCx() {
        return this.centerX;
    }

    int getCy() {
        return this.centerY;
    }

    boolean hasMoved() {
        if (this.moved) {
            this.moved = false;
            return true;
        }
        return false;
    }

    private void updateCoord(MouseEvent event) {
        this.oldX = this.x;
        this.oldY = this.y;
        this.x = event.getXOnScreen();
        this.y = event.getYOnScreen();
        this.wx = event.getX();
        this.wy = event.getY();
        this.mx = this.x - this.oldX;
        this.my = this.y - this.oldY;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.moved = true;
        this.updateCoord(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.moved = true;
        this.updateCoord(event);
    }
}

