/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.Constant;
import com.b3dgs.lionengine.Engine;
import com.b3dgs.lionengine.Medias;
import com.b3dgs.lionengine.UtilFolder;
import com.b3dgs.lionengine.Verbose;
import com.b3dgs.lionengine.Version;
import com.b3dgs.lionengine.audio.AudioFactory;
import com.b3dgs.lionengine.awt.graphic.FactoryGraphicAwt;
import com.b3dgs.lionengine.graphic.FactoryGraphic;
import com.b3dgs.lionengine.graphic.Graphics;
import java.util.Optional;

public class EngineAwt
extends Engine {
    private static final String PROPERTY_USER_DIR = "user.dir";
    private final Optional<String> resourcesDir;
    private final Optional<Class<?>> classResource;

    public static void start(String name, Version version) {
        Engine.start((Engine)new EngineAwt(name, version, ""));
    }

    public static void start(String name, Version version, String resourcesDir) {
        Engine.start((Engine)new EngineAwt(name, version, resourcesDir));
    }

    public static void start(String name, Version version, Class<?> classResource) {
        Engine.start((Engine)new EngineAwt(name, version, classResource));
    }

    public EngineAwt(String name, Version version, String resourcesDir) {
        super(name, version);
        Check.notNull((Object)resourcesDir);
        this.resourcesDir = Optional.of(resourcesDir);
        this.classResource = Optional.empty();
        Medias.setResourcesDirectory((String)resourcesDir);
    }

    public EngineAwt(String name, Version version, Class<?> classResource) {
        super(name, version);
        Check.notNull(classResource);
        this.classResource = Optional.of(classResource);
        this.resourcesDir = Optional.empty();
        Medias.setLoadFromJar(classResource);
    }

    protected void open() {
        Graphics.setFactoryGraphic((FactoryGraphic)new FactoryGraphicAwt());
        if (this.resourcesDir.isPresent()) {
            String workingDir = Constant.getSystemProperty((String)PROPERTY_USER_DIR, (String)"");
            Verbose.info((String[])new String[]{"Resources directory = ", UtilFolder.getPath((String[])new String[]{workingDir, this.resourcesDir.get()})});
        } else {
            Verbose.info((String[])new String[]{"Class resources = ", this.classResource.get().getName()});
        }
    }

    protected void close() {
        Medias.setResourcesDirectory(null);
        Medias.setLoadFromJar(null);
        Graphics.setFactoryGraphic(null);
        AudioFactory.clearFormats();
    }
}

