/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.Config;
import com.b3dgs.lionengine.LionEngineException;
import com.b3dgs.lionengine.Media;
import com.b3dgs.lionengine.UtilMath;
import com.b3dgs.lionengine.awt.graphic.GraphicAwt;
import com.b3dgs.lionengine.awt.graphic.ImageBufferAwt;
import com.b3dgs.lionengine.awt.graphic.ScreenBaseAwt;
import com.b3dgs.lionengine.awt.graphic.ScreenFullAwt;
import com.b3dgs.lionengine.awt.graphic.ScreenWindowedAwt;
import com.b3dgs.lionengine.awt.graphic.TextAwt;
import com.b3dgs.lionengine.awt.graphic.ToolsAwt;
import com.b3dgs.lionengine.awt.graphic.TransformAwt;
import com.b3dgs.lionengine.graphic.ColorRgba;
import com.b3dgs.lionengine.graphic.FactoryGraphic;
import com.b3dgs.lionengine.graphic.Graphic;
import com.b3dgs.lionengine.graphic.ImageBuffer;
import com.b3dgs.lionengine.graphic.ImageSurface;
import com.b3dgs.lionengine.graphic.Screen;
import com.b3dgs.lionengine.graphic.Text;
import com.b3dgs.lionengine.graphic.TextStyle;
import com.b3dgs.lionengine.graphic.Transform;
import com.b3dgs.lionengine.graphic.Transparency;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FactoryGraphicAwt
implements FactoryGraphic {
    static final String ERROR_IMAGE_READING = "Error on reading image !";
    static final String ERROR_IMAGE_SAVE = "Unable to save image: ";

    public Screen createScreen(Config config) {
        Check.notNull((Object)config);
        ScreenBaseAwt screen = config.isWindowed() ? new ScreenWindowedAwt(config) : new ScreenFullAwt(config);
        return screen;
    }

    public Graphic createGraphic() {
        return new GraphicAwt();
    }

    public Transform createTransform() {
        return new TransformAwt();
    }

    public Text createText(String fontName, int size, TextStyle style) {
        return new TextAwt(fontName, size, style);
    }

    public ImageBuffer createImageBuffer(int width, int height) {
        BufferedImage image = ToolsAwt.createImage(width, height, 1);
        ImageBufferAwt buffer = new ImageBufferAwt(image);
        Graphic g = buffer.createGraphic();
        g.setColor(ColorRgba.BLACK);
        g.drawRect(0, 0, width, height, true);
        g.dispose();
        return buffer;
    }

    public ImageBuffer createImageBuffer(int width, int height, ColorRgba transparency) {
        Check.notNull((Object)transparency);
        BufferedImage image = ToolsAwt.createImage(width, height, 2);
        ImageBufferAwt buffer = new ImageBufferAwt(image);
        Graphic g = buffer.createGraphic();
        g.setColor(transparency);
        g.drawRect(0, 0, width, height, true);
        g.dispose();
        return buffer;
    }

    public ImageBuffer getImageBuffer(Media media) {
        ImageBufferAwt imageBufferAwt;
        block8: {
            Check.notNull((Object)media);
            InputStream input = media.getInputStream();
            try {
                imageBufferAwt = new ImageBufferAwt(ToolsAwt.getImage(input));
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LionEngineException | IOException exception) {
                    throw new LionEngineException(exception, media, ERROR_IMAGE_READING);
                }
            }
            input.close();
        }
        return imageBufferAwt;
    }

    public ImageBuffer getImageBuffer(ImageBuffer image) {
        Check.notNull((Object)image);
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.copyImage(surface));
    }

    public ImageBuffer applyMask(ImageBuffer image, ColorRgba maskColor) {
        Check.notNull((Object)image);
        Check.notNull((Object)maskColor);
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.applyMask(surface, maskColor.getRgba()));
    }

    public ImageBuffer[] splitImage(ImageBuffer image, int h, int v) {
        Check.notNull((Object)image);
        BufferedImage surface = (BufferedImage)image.getSurface();
        BufferedImage[] images = ToolsAwt.splitImage(surface, h, v);
        ImageBuffer[] imageBuffers = new ImageBuffer[h * v];
        for (int i = 0; i < imageBuffers.length; ++i) {
            imageBuffers[i] = new ImageBufferAwt(images[i]);
        }
        return imageBuffers;
    }

    public ImageBuffer rotate(ImageBuffer image, int angle) {
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.rotate(surface, angle));
    }

    public ImageBuffer resize(ImageBuffer image, int width, int height) {
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.resize(surface, width, height));
    }

    public ImageBuffer flipHorizontal(ImageBuffer image) {
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.flipHorizontal(surface));
    }

    public ImageBuffer flipVertical(ImageBuffer image) {
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.flipVertical(surface));
    }

    public void saveImage(ImageBuffer image, Media media) {
        Check.notNull((Object)media);
        BufferedImage surface = (BufferedImage)image.getSurface();
        try (OutputStream output = media.getOutputStream();){
            ToolsAwt.saveImage(surface, output);
        }
        catch (IOException exception) {
            throw new LionEngineException((Throwable)exception, media, ERROR_IMAGE_SAVE);
        }
    }

    public void generateTileset(ImageBuffer[] images, Media media) {
        Check.notNull((Object)images);
        Check.notNull((Object)media);
        if (images.length == 0) {
            throw new LionEngineException("No images found !");
        }
        int width = images[0].getWidth();
        int height = images[0].getHeight();
        Transparency transparency = images[0].getTransparency();
        int multDistance = (int)Math.ceil((double)(width * images.length) / (double)height) / 4;
        int[] mult = UtilMath.getClosestSquareMult((int)images.length, (int)multDistance);
        ImageBufferAwt tile = new ImageBufferAwt(ToolsAwt.createImage(width * mult[1], height * mult[0], ToolsAwt.getTransparency(transparency)));
        int x = 0;
        int y = 0;
        int line = 0;
        Graphic g = tile.createGraphic();
        for (ImageBuffer b : images) {
            g.drawImage((ImageSurface)b, x, y);
            x += b.getWidth();
            if (++line != mult[1]) continue;
            x = 0;
            y += b.getHeight();
            line = 0;
        }
        g.dispose();
        this.saveImage(tile, media);
    }

    public ImageBuffer getRasterBuffer(ImageBuffer image, double fr, double fg, double fb) {
        Check.notNull((Object)image);
        BufferedImage surface = (BufferedImage)image.getSurface();
        return new ImageBufferAwt(ToolsAwt.getRasterBuffer(surface, fr, fg, fb));
    }

    public ImageBuffer[] getRasterBuffer(ImageBuffer image, ImageBuffer palette) {
        Check.notNull((Object)image);
        Check.notNull((Object)palette);
        BufferedImage[] rasters = ToolsAwt.getRasterBuffer((BufferedImage)image.getSurface(), (BufferedImage)palette.getSurface());
        ImageBuffer[] buffers = new ImageBuffer[rasters.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new ImageBufferAwt(rasters[i]);
        }
        return buffers;
    }

    public ImageBuffer[] getRasterBufferSmooth(ImageBuffer image, ImageBuffer palette, int tileHeight) {
        Check.notNull((Object)image);
        Check.notNull((Object)palette);
        BufferedImage[] rasters = ToolsAwt.getRasterBufferSmooth((BufferedImage)image.getSurface(), (BufferedImage)palette.getSurface(), tileHeight);
        ImageBuffer[] buffers = new ImageBuffer[rasters.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new ImageBufferAwt(rasters[i]);
        }
        return buffers;
    }

    public ImageBuffer[] getRasterBufferSmooth(ImageBuffer image, ImageBuffer palette, int fh, int fv) {
        Check.notNull((Object)image);
        Check.notNull((Object)palette);
        BufferedImage[] rasters = ToolsAwt.getRasterBufferSmooth((BufferedImage)image.getSurface(), (BufferedImage)palette.getSurface(), fh, fv);
        ImageBuffer[] buffers = new ImageBuffer[rasters.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new ImageBufferAwt(rasters[i]);
        }
        return buffers;
    }

    public ImageBuffer[] getRasterBufferOffset(Media image, Media palette, Media raster, int offsets) {
        BufferedImage[] rasters = ToolsAwt.getRasterBufferOffset((BufferedImage)this.getImageBuffer(image).getSurface(), (BufferedImage)this.getImageBuffer(palette).getSurface(), (BufferedImage)this.getImageBuffer(raster).getSurface(), offsets);
        ImageBuffer[] buffers = new ImageBuffer[rasters.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = new ImageBufferAwt(rasters[i]);
        }
        return buffers;
    }
}

