/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Origin;
import com.b3dgs.lionengine.UtilMath;
import com.b3dgs.lionengine.Viewer;
import com.b3dgs.lionengine.graphic.ColorGradient;
import com.b3dgs.lionengine.graphic.ColorRgba;
import com.b3dgs.lionengine.graphic.Graphic;
import com.b3dgs.lionengine.graphic.ImageSurface;
import com.b3dgs.lionengine.graphic.Transform;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

final class GraphicAwt
implements Graphic {
    private Graphics2D g;
    private GradientPaint gradientPaint;
    private Transform lastTransform;
    private AffineTransformOp op;

    GraphicAwt() {
        this.g = null;
    }

    GraphicAwt(Graphics2D g) {
        this.g = g;
    }

    public void clear(int x, int y, int width, int height) {
        this.g.clearRect(x, y, width, height);
    }

    public void dispose() {
        this.g.dispose();
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.g.copyArea(x, y, width, height, dx, dy);
    }

    public void drawImage(ImageSurface image, int x, int y) {
        this.g.drawImage((BufferedImage)image.getSurface(), null, x, y);
    }

    public void drawImage(ImageSurface image, Transform transform, int x, int y) {
        if (this.lastTransform != transform) {
            this.lastTransform = transform;
            AffineTransform at = new AffineTransform();
            at.scale(transform.getScaleX(), transform.getScaleY());
            int interpolation = UtilMath.clamp((int)transform.getInterpolation(), (int)1, (int)3);
            this.op = new AffineTransformOp(at, interpolation);
        }
        this.g.drawImage((BufferedImage)image.getSurface(), this.op, x, y);
    }

    public void drawImage(ImageSurface image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.g.drawImage((BufferedImage)image.getSurface(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public void drawImage(ImageSurface image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, int angle, int angleX, int angleY) {
        if (angle == 0) {
            this.g.drawImage((BufferedImage)image.getSurface(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
        } else {
            double ax = (double)(dx2 - sx1) + (double)angleX;
            double ay = (double)(dy2 - sy1) + (double)angleY;
            AffineTransform old = this.g.getTransform();
            AffineTransform tx = AffineTransform.getRotateInstance(Math.toRadians(angle), ax, ay);
            this.g.setTransform(tx);
            this.g.drawImage((BufferedImage)image.getSurface(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
            this.g.setTransform(old);
        }
    }

    public void drawRect(int x, int y, int width, int height, boolean fill) {
        if (fill) {
            this.g.fillRect(x, y, width, height);
        } else {
            this.g.drawRect(x, y, width, height);
        }
    }

    public void drawRect(Viewer viewer, Origin origin, double x, double y, int width, int height, boolean fill) {
        int px = (int)Math.round(origin.getX(viewer.getViewpointX(x), (double)width));
        int py = (int)Math.round(origin.getY(viewer.getViewpointY(y), (double)height));
        this.drawRect(px, py, width, height, fill);
    }

    public void drawGradient(int x, int y, int width, int height) {
        this.g.setPaint(this.gradientPaint);
        this.g.fillRect(x, y, width, height);
        this.g.setPaint(null);
    }

    public void drawGradient(Viewer viewer, Origin origin, double x, double y, int width, int height) {
        int px = (int)Math.round(origin.getX(viewer.getViewpointX(x), (double)width));
        int py = (int)Math.round(origin.getY(viewer.getViewpointY(y), (double)height));
        this.drawGradient(px, py, width, height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void drawLine(Viewer viewer, double x1, double y1, double x2, double y2) {
        this.g.drawLine((int)Math.round(viewer.getViewpointX(x1)), (int)Math.round(viewer.getViewpointY(y1)), (int)Math.round(viewer.getViewpointX(x2)), (int)Math.round(viewer.getViewpointY(y2)));
    }

    public void drawOval(int x, int y, int width, int height, boolean fill) {
        if (fill) {
            this.g.fillOval(x, y, width, height);
        } else {
            this.g.drawOval(x, y, width, height);
        }
    }

    public void drawOval(Viewer viewer, Origin origin, double x, double y, int width, int height, boolean fill) {
        int px = (int)Math.round(origin.getX(viewer.getViewpointX(x), (double)width));
        int py = (int)Math.round(origin.getY(viewer.getViewpointY(y), (double)height));
        this.drawOval(px, py, width, height, fill);
    }

    public void setColor(ColorRgba color) {
        this.g.setColor(new Color(color.getRgba(), true));
    }

    public void setColorGradient(ColorGradient gc) {
        Color color1 = new Color(gc.getColor1().getRgba());
        Color color2 = new Color(gc.getColor2().getRgba());
        this.gradientPaint = new GradientPaint(gc.getX1(), gc.getY1(), color1, gc.getX2(), gc.getY2(), color2);
    }

    public void setGraphic(Object graphic) {
        this.g = graphic instanceof Graphics2D ? (Graphics2D)graphic : (graphic instanceof GraphicAwt ? ((GraphicAwt)graphic).g : null);
    }

    public Object getGraphic() {
        return this.g;
    }

    public ColorRgba getColor() {
        return new ColorRgba(this.g.getColor().getRGB());
    }
}

