/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.UtilConversion;
import com.b3dgs.lionengine.awt.graphic.GraphicAwt;
import com.b3dgs.lionengine.graphic.ColorRgba;
import com.b3dgs.lionengine.graphic.Graphic;
import com.b3dgs.lionengine.graphic.ImageBuffer;
import com.b3dgs.lionengine.graphic.Transparency;
import java.awt.image.BufferedImage;

final class ImageBufferAwt
implements ImageBuffer {
    private final BufferedImage bufferedImage;

    ImageBufferAwt(BufferedImage bufferedImage) {
        Check.notNull((Object)bufferedImage);
        this.bufferedImage = bufferedImage;
    }

    public void prepare() {
    }

    public Graphic createGraphic() {
        return new GraphicAwt(this.bufferedImage.createGraphics());
    }

    public void dispose() {
    }

    public void setRgb(int x, int y, int rgb) {
        this.bufferedImage.setRGB(x, y, rgb);
    }

    public void setRgb(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        this.bufferedImage.setRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public int getRgb(int x, int y) {
        int pixel = this.bufferedImage.getRGB(x, y);
        if (UtilConversion.mask((int)(pixel >> 24)) == 0) {
            return ColorRgba.TRANSPARENT.getRgba();
        }
        return pixel;
    }

    public int[] getRgb(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        return this.bufferedImage.getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public int getWidth() {
        return this.bufferedImage.getWidth();
    }

    public int getHeight() {
        return this.bufferedImage.getHeight();
    }

    public BufferedImage getSurface() {
        return this.bufferedImage;
    }

    public Transparency getTransparency() {
        Transparency value;
        switch (this.bufferedImage.getTransparency()) {
            case 1: {
                value = Transparency.OPAQUE;
                break;
            }
            case 2: {
                value = Transparency.BITMASK;
                break;
            }
            default: {
                value = Transparency.TRANSLUCENT;
            }
        }
        return value;
    }

    public ColorRgba getTransparentColor() {
        return ColorRgba.TRANSPARENT;
    }
}

