/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.Config;
import com.b3dgs.lionengine.InputDeviceKeyListener;
import com.b3dgs.lionengine.LionEngineException;
import com.b3dgs.lionengine.Resolution;
import com.b3dgs.lionengine.Verbose;
import com.b3dgs.lionengine.awt.Keyboard;
import com.b3dgs.lionengine.awt.KeyboardAwt;
import com.b3dgs.lionengine.awt.KeyboardAwtListener;
import com.b3dgs.lionengine.awt.Mouse;
import com.b3dgs.lionengine.awt.MouseAwt;
import com.b3dgs.lionengine.awt.graphic.ToolsAwt;
import com.b3dgs.lionengine.graphic.ScreenAbstract;
import com.b3dgs.lionengine.graphic.ScreenListener;
import com.b3dgs.lionengine.io.InputDeviceDirectional;
import com.b3dgs.lionengine.io.InputDevicePointer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferStrategy;

abstract class ScreenAwtAbstract
extends ScreenAbstract
implements FocusListener {
    private static final String ERROR_DISPLAY = "No available display !";
    private static final Cursor CURSOR_HIDDEN = ToolsAwt.createHiddenCursor();
    private static final Cursor CURSOR_DEFAULT = Cursor.getDefaultCursor();
    private static final long READY_TIMEOUT = 5000L;
    protected BufferStrategy buf;
    protected Component componentForKeyboard;
    protected Component componentForMouse;
    protected Component componentForCursor;
    private int width;
    private int height;

    protected ScreenAwtAbstract(Config config) {
        super(config, 5000L);
        if (GraphicsEnvironment.isHeadless()) {
            throw new LionEngineException(ERROR_DISPLAY);
        }
    }

    protected void setResolution(Resolution output) {
        Check.notNull((Object)output);
        this.width = output.getWidth();
        this.height = output.getHeight();
    }

    private void addKeyboardListener(KeyboardAwt keyboard) {
        this.componentForKeyboard.addKeyListener(keyboard);
        this.componentForKeyboard.requestFocus();
        this.componentForKeyboard.setFocusTraversalKeysEnabled(false);
    }

    private void addMouseListener(MouseAwt mouse) {
        this.componentForMouse.addMouseListener(mouse.getClicker());
        this.componentForMouse.addMouseMotionListener(mouse.getMover());
        this.componentForMouse.requestFocus();
    }

    private void addDeviceKeyboard() {
        KeyboardAwt keyboard = new KeyboardAwt();
        this.addKeyboardListener(keyboard);
        this.devices.put(Keyboard.class, keyboard);
        this.devices.put(InputDeviceDirectional.class, keyboard);
    }

    private void addDeviceMouse() {
        MouseAwt mouse = new MouseAwt();
        this.addMouseListener(mouse);
        this.devices.put(Mouse.class, mouse);
        this.devices.put(InputDevicePointer.class, mouse);
    }

    private void prepareFocusListener() {
        this.componentForMouse.addFocusListener(this);
    }

    public void start() {
        super.start();
        this.setResolution(this.config.getOutput());
        this.prepareFocusListener();
        this.addDeviceKeyboard();
        this.addDeviceMouse();
        this.buf.show();
        this.graphics.setGraphic((Object)this.buf.getDrawGraphics());
    }

    public void preUpdate() {
    }

    public void update() {
        this.buf.show();
        this.graphics.setGraphic((Object)this.buf.getDrawGraphics());
    }

    public void dispose() {
        this.graphics.clear(0, 0, this.width, this.height);
        this.update();
    }

    public void requestFocus() {
        this.componentForMouse.requestFocus();
    }

    public void hideCursor() {
        this.componentForCursor.setCursor(CURSOR_HIDDEN);
    }

    public void showCursor() {
        this.componentForCursor.setCursor(CURSOR_DEFAULT);
    }

    public void addKeyListener(InputDeviceKeyListener listener) {
        this.componentForKeyboard.addKeyListener(new KeyboardAwtListener(listener));
    }

    public int getX() {
        try {
            return (int)this.componentForMouse.getLocationOnScreen().getX();
        }
        catch (IllegalComponentStateException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[0]);
            return 0;
        }
    }

    public int getY() {
        try {
            return (int)this.componentForMouse.getLocationOnScreen().getY();
        }
        catch (IllegalComponentStateException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[0]);
            return 0;
        }
    }

    public boolean isReady() {
        return this.buf != null;
    }

    public void onSourceChanged(Resolution source) {
        ((MouseAwt)this.getInputDevice(Mouse.class)).setResolution(this.config.getOutput(), source);
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.listeners.forEach(ScreenListener::notifyFocusGained);
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.listeners.forEach(ScreenListener::notifyFocusLost);
    }
}

