/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Config;
import com.b3dgs.lionengine.Constant;
import com.b3dgs.lionengine.Engine;
import com.b3dgs.lionengine.Media;
import com.b3dgs.lionengine.awt.graphic.ScreenAwtAbstract;
import com.b3dgs.lionengine.graphic.ScreenListener;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

class ScreenBaseAwt
extends ScreenAwtAbstract {
    protected final GraphicsDevice dev;
    protected final GraphicsConfiguration conf;
    protected final JFrame frame;

    ScreenBaseAwt(Config config) {
        super(config);
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.dev = env.getDefaultScreenDevice();
        this.conf = this.dev.getDefaultConfiguration();
        this.frame = this.initMainFrame();
    }

    private JFrame initMainFrame() {
        String title = ScreenBaseAwt.getTitle();
        JFrame jframe = new JFrame(title, this.conf);
        jframe.setDefaultCloseOperation(0);
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                ScreenBaseAwt.this.listeners.forEach(ScreenListener::notifyClosed);
            }
        });
        jframe.setResizable(false);
        jframe.setUndecorated(false);
        jframe.setIgnoreRepaint(true);
        return jframe;
    }

    private static String getTitle() {
        StringBuilder builder = new StringBuilder(24);
        if (Engine.isStarted()) {
            builder.append(Engine.getProgramName()).append(" ").append(Engine.getProgramVersion());
        } else {
            builder.append("LionEngine").append(" ").append(Constant.ENGINE_VERSION);
        }
        return builder.toString();
    }

    @Override
    public void start() {
        super.start();
        this.frame.validate();
        this.frame.setEnabled(true);
        this.frame.setVisible(true);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.buf.dispose();
        this.frame.dispose();
    }

    @Override
    public void requestFocus() {
        this.frame.requestFocus();
        super.requestFocus();
    }

    public void setIcons(Collection<Media> icons) {
        this.frame.setIconImages(icons.stream().map(i -> new ImageIcon(i.getUrl()).getImage()).collect(Collectors.toList()));
    }
}

