/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.Config;
import com.b3dgs.lionengine.Generated;
import com.b3dgs.lionengine.LionEngineException;
import com.b3dgs.lionengine.Resolution;
import com.b3dgs.lionengine.awt.graphic.ScreenBaseAwt;
import com.b3dgs.lionengine.awt.graphic.ToolsAwt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Window;

final class ScreenFullAwt
extends ScreenBaseAwt {
    static final String ERROR_UNSUPPORTED_FULLSCREEN = "Unsupported resolution: ";
    static final String ERROR_SWITCH = "Unable to switch to full screen mode !";
    private static final int MIN_LENGTH = 18;

    private static String formatResolution(Resolution resolution, int depth) {
        return new StringBuilder(18).append(String.valueOf(resolution.getWidth())).append("*").append(String.valueOf(resolution.getHeight())).append("*").append(depth).append(" ").append("@").append(String.valueOf(resolution.getRate())).append("Hz").toString();
    }

    ScreenFullAwt(Config config) {
        super(config);
        this.frame.setUndecorated(true);
    }

    private void initFullscreen(Resolution output, int depth) {
        Window window = new Window(this.frame, this.conf);
        window.setBackground(Color.BLACK);
        window.setIgnoreRepaint(true);
        window.setPreferredSize(new Dimension(output.getWidth(), output.getHeight()));
        this.dev.setFullScreenWindow(window);
        DisplayMode disp = this.isSupported(new DisplayMode(output.getWidth(), output.getHeight(), depth, output.getRate()));
        if (disp == null) {
            throw new LionEngineException(ERROR_UNSUPPORTED_FULLSCREEN + ScreenFullAwt.formatResolution(output, depth) + this.getSupportedResolutions());
        }
        this.checkDisplayChangeSupport();
        this.dev.setDisplayMode(disp);
        window.validate();
        ToolsAwt.createBufferStrategy(window, this.conf);
        this.buf = window.getBufferStrategy();
        this.componentForKeyboard = this.frame;
        this.componentForMouse = window;
        this.componentForCursor = window;
        this.frame.validate();
    }

    @Generated
    private void checkDisplayChangeSupport() {
        if (!this.dev.isDisplayChangeSupported()) {
            throw new LionEngineException(ERROR_SWITCH);
        }
    }

    private String getSupportedResolutions() {
        StringBuilder builder = new StringBuilder(100);
        int i = 0;
        for (DisplayMode display : this.dev.getDisplayModes()) {
            StringBuilder widthSpace = new StringBuilder();
            int width = display.getWidth();
            if (width < 1000) {
                widthSpace.append(" ");
            }
            StringBuilder heightSpace = new StringBuilder();
            int height = display.getHeight();
            if (height < 1000) {
                heightSpace.append(System.lineSeparator());
            }
            StringBuilder freqSpace = new StringBuilder();
            int freq = display.getRefreshRate();
            if (freq < 100) {
                freqSpace.append(" ");
            }
            builder.append("Supported display mode:").append(System.lineSeparator()).append('[').append((CharSequence)widthSpace).append(width).append("*").append((CharSequence)heightSpace).append(height).append("*").append(display.getBitDepth()).append(" ").append("@").append((CharSequence)freqSpace).append(freq).append("Hz").append(']').append(" ");
            int linesPerDisplay = 5;
            if (++i % 5 != 0) continue;
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    private DisplayMode isSupported(DisplayMode display) {
        DisplayMode[] supported;
        for (DisplayMode current : supported = this.dev.getDisplayModes()) {
            if (!ToolsAwt.sameDisplay(display, current)) continue;
            return current;
        }
        return null;
    }

    @Override
    protected void setResolution(Resolution output) {
        Check.notNull((Object)output);
        this.initFullscreen(output, this.config.getDepth());
        super.setResolution(output);
    }
}

