/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Align;
import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.LionEngineException;
import com.b3dgs.lionengine.graphic.ColorRgba;
import com.b3dgs.lionengine.graphic.Graphic;
import com.b3dgs.lionengine.graphic.Text;
import com.b3dgs.lionengine.graphic.TextStyle;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;

final class TextAwt
implements Text {
    private final Font font;
    private final int size;
    private int x;
    private int y;
    private int w;
    private int h;
    private String txt;
    private Align align = Align.LEFT;
    private ColorRgba color = ColorRgba.WHITE;
    private boolean txtChanged;

    private static int getStyle(TextStyle style) {
        int value;
        if (TextStyle.NORMAL == style) {
            value = 0;
        } else if (TextStyle.BOLD == style) {
            value = 1;
        } else if (TextStyle.ITALIC == style) {
            value = 2;
        } else {
            throw new LionEngineException((Enum)style);
        }
        return value;
    }

    TextAwt(String fontName, int size, TextStyle style) {
        Check.notNull((Object)fontName);
        Check.notNull((Object)style);
        this.size = size;
        this.font = new Font(fontName, TextAwt.getStyle(style), size);
    }

    public void draw(Graphic g, int x, int y, String text) {
        this.draw(g, x, y, Align.LEFT, text);
    }

    public void draw(Graphic g, int x, int y, Align alignment, String text) {
        int ty;
        int tx;
        Graphics2D g2d = (Graphics2D)g.getGraphic();
        FontRenderContext context = g2d.getFontRenderContext();
        Rectangle2D textSize = this.font.getStringBounds(text, context);
        if (Align.LEFT == alignment) {
            tx = x;
            ty = (int)textSize.getHeight() + y;
        } else if (Align.CENTER == alignment) {
            tx = x - (int)textSize.getWidth() / 2;
            ty = (int)textSize.getHeight() + y;
        } else if (Align.RIGHT == alignment) {
            tx = x - (int)textSize.getWidth();
            ty = (int)textSize.getHeight() + y;
        } else {
            throw new LionEngineException((Enum)alignment);
        }
        ColorRgba colorOld = g.getColor();
        g.setColor(this.color);
        GlyphVector glyphVector = this.font.createGlyphVector(context, text);
        g2d.drawGlyphVector(glyphVector, tx, (float)ty - (float)this.size / 2.0f);
        g.setColor(colorOld);
    }

    public void render(Graphic g) {
        this.draw(g, this.x, this.y, this.align, this.txt);
        if (this.txtChanged) {
            this.w = this.getStringWidth(g, this.txt);
            this.h = this.getStringHeight(g, this.txt);
            this.txtChanged = false;
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setText(String text) {
        this.txt = text;
        this.txtChanged = true;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public void setColor(ColorRgba color) {
        this.color = color;
    }

    public int getSize() {
        return this.size;
    }

    public int getLocationX() {
        return this.x;
    }

    public int getLocationY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public int getStringWidth(Graphic g, String str) {
        return (int)this.font.getStringBounds(str, ((Graphics2D)g.getGraphic()).getFontRenderContext()).getWidth();
    }

    public int getStringHeight(Graphic g, String str) {
        return (int)this.font.getStringBounds(str, ((Graphics2D)g.getGraphic()).getFontRenderContext()).getHeight();
    }
}

