/*
 * Decompiled with CFR 0.152.
 */
package com.b3dgs.lionengine.awt.graphic;

import com.b3dgs.lionengine.Check;
import com.b3dgs.lionengine.LionEngineException;
import com.b3dgs.lionengine.UtilMath;
import com.b3dgs.lionengine.Verbose;
import com.b3dgs.lionengine.awt.graphic.ImageBufferAwt;
import com.b3dgs.lionengine.geom.Rectangle;
import com.b3dgs.lionengine.graphic.ImageBuffer;
import com.b3dgs.lionengine.graphic.Transparency;
import com.b3dgs.lionengine.graphic.UtilColor;
import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public final class ToolsAwt {
    private static final GraphicsEnvironment ENV = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private static final GraphicsDevice DEV = ENV.getDefaultScreenDevice();
    private static final GraphicsConfiguration CONFIG = DEV.getDefaultConfiguration();

    public static boolean sameDisplay(DisplayMode a, DisplayMode b) {
        boolean multiDepth = b.getBitDepth() != -1 && a.equals(b);
        return multiDepth || b.getBitDepth() == -1 && a.getWidth() == b.getWidth() && a.getHeight() == b.getHeight();
    }

    public static int getTransparency(Transparency transparency) {
        int value;
        Check.notNull((Object)transparency);
        if (Transparency.OPAQUE == transparency) {
            value = 1;
        } else if (Transparency.BITMASK == transparency) {
            value = 2;
        } else if (Transparency.TRANSLUCENT == transparency) {
            value = 3;
        } else {
            throw new LionEngineException((Enum)transparency);
        }
        return value;
    }

    public static BufferedImage createImage(int width, int height, int transparency) {
        Check.superiorStrict((int)width, (int)0);
        Check.superiorStrict((int)height, (int)0);
        return CONFIG.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage getImage(InputStream input) throws IOException {
        BufferedImage buffer = ImageIO.read(input);
        if (buffer == null) {
            throw new IOException("Invalid image !");
        }
        return ToolsAwt.copyImage(buffer);
    }

    public static ImageBuffer getImageBuffer(BufferedImage image) {
        return new ImageBufferAwt(image);
    }

    public static void saveImage(BufferedImage image, OutputStream output) throws IOException {
        ImageIO.write((RenderedImage)image, "png", output);
    }

    public static BufferedImage copyImage(BufferedImage image) {
        BufferedImage copy = ToolsAwt.createImage(image.getWidth(), image.getHeight(), image.getColorModel().getTransparency());
        Graphics2D g = copy.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return copy;
    }

    public static int[] getImageData(BufferedImage image) {
        return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
    }

    public static BufferedImage applyMask(BufferedImage image, int rgba) {
        BufferedImage mask = ToolsAwt.copyImage(image);
        int height = mask.getHeight();
        int width = mask.getWidth();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int col = mask.getRGB(x, y);
                int flag = 0xFFFFFF;
                if (col != rgba) continue;
                mask.setRGB(x, y, col & 0xFFFFFF);
            }
        }
        return mask;
    }

    public static BufferedImage rotate(BufferedImage image, int angle) {
        int width = image.getWidth();
        int height = image.getHeight();
        int transparency = image.getColorModel().getTransparency();
        Rectangle rectangle = new Rectangle(0.0, 0.0, (double)width, (double)height);
        rectangle.rotate((double)angle);
        BufferedImage rotated = ToolsAwt.createImage(rectangle.getWidth(), rectangle.getHeight(), transparency);
        Graphics2D g = rotated.createGraphics();
        ToolsAwt.optimizeGraphicsSpeed(g);
        g.rotate(Math.toRadians(angle), (double)rectangle.getWidth() / 2.0, (double)rectangle.getHeight() / 2.0);
        double ox = (double)rectangle.getWidth() - (double)width;
        double oy = (double)rectangle.getHeight() - (double)height;
        double cos = UtilMath.cos((double)angle);
        double sin = UtilMath.sin((double)angle);
        double angleOffsetX = sin * ox + cos * oy;
        double angleOffsetY = -sin * oy + cos * ox;
        g.drawImage(image, null, (int)((ox - angleOffsetX) / 2.0), (int)((oy - angleOffsetY) / 2.0));
        g.dispose();
        return rotated;
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        int transparency = image.getColorModel().getTransparency();
        BufferedImage resized = ToolsAwt.createImage(width, height, transparency);
        Graphics2D g = resized.createGraphics();
        ToolsAwt.optimizeGraphicsSpeed(g);
        g.drawImage(image, 0, 0, width, height, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return resized;
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage flipped = ToolsAwt.createImage(width, height, image.getColorModel().getTransparency());
        Graphics2D g = flipped.createGraphics();
        ToolsAwt.optimizeGraphicsSpeed(g);
        g.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        g.dispose();
        return flipped;
    }

    public static BufferedImage flipVertical(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage flipped = ToolsAwt.createImage(width, height, image.getColorModel().getTransparency());
        Graphics2D g = flipped.createGraphics();
        ToolsAwt.optimizeGraphicsSpeed(g);
        g.drawImage(image, 0, 0, width, height, 0, height, width, 0, null);
        g.dispose();
        return flipped;
    }

    public static BufferedImage[] splitImage(BufferedImage image, int h, int v) {
        int width = image.getWidth() / h;
        int height = image.getHeight() / v;
        int transparency = image.getColorModel().getTransparency();
        BufferedImage[] images = new BufferedImage[h * v];
        int frame = 0;
        for (int y = 0; y < v; ++y) {
            for (int x = 0; x < h; ++x) {
                images[frame] = ToolsAwt.createImage(width, height, transparency);
                Graphics2D g = images[frame].createGraphics();
                ToolsAwt.optimizeGraphicsSpeed(g);
                g.drawImage(image, 0, 0, width, height, x * width, y * height, (x + 1) * width, (y + 1) * height, null);
                g.dispose();
                ++frame;
            }
        }
        return images;
    }

    public static BufferedImage getRasterBuffer(BufferedImage image, double fr, double fg, double fb) {
        BufferedImage raster = ToolsAwt.createImage(image.getWidth(), image.getHeight(), image.getTransparency());
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                raster.setRGB(i, j, UtilColor.multiplyRgb((int)image.getRGB(i, j), (double)fr, (double)fg, (double)fb));
            }
        }
        return raster;
    }

    public static BufferedImage[] getRasterBuffer(BufferedImage image, BufferedImage palette) {
        int rastersCount = palette.getHeight() - 1;
        BufferedImage[] rasters = new BufferedImage[rastersCount];
        for (int rasterIndex = 0; rasterIndex < rastersCount; ++rasterIndex) {
            rasters[rasterIndex] = ToolsAwt.getRasterBuffer(image, palette, rasterIndex);
        }
        return rasters;
    }

    private static BufferedImage getRasterBuffer(BufferedImage image, BufferedImage palette, int rasterIndex) {
        int width = image.getWidth();
        int height = image.getHeight();
        int paletteColors = palette.getWidth();
        BufferedImage raster = ToolsAwt.createImage(width, height, image.getTransparency());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int originalRgb = image.getRGB(x, y);
                raster.setRGB(x, y, ToolsAwt.findRaster(paletteColors, palette, originalRgb, rasterIndex));
            }
        }
        return raster;
    }

    public static BufferedImage[] getRasterBufferSmooth(BufferedImage image, BufferedImage palette, int tileHeight) {
        int height = image.getHeight();
        BufferedImage[] rasters = new BufferedImage[tileHeight];
        for (int maxHeight = 0; maxHeight < tileHeight; ++maxHeight) {
            BufferedImage raster = ToolsAwt.createImage(image.getWidth(), height, image.getTransparency());
            for (int ty = 0; ty < height / tileHeight; ++ty) {
                ToolsAwt.fillBuffer(image, palette, raster, tileHeight, maxHeight, ty);
            }
            rasters[maxHeight] = raster;
        }
        return rasters;
    }

    public static BufferedImage[] getRasterBufferSmooth(BufferedImage image, BufferedImage palette, int fh, int fv) {
        int height = image.getHeight();
        int frameHeight = height / fv;
        BufferedImage[] rasters = new BufferedImage[frameHeight];
        for (int maxHeight = 0; maxHeight < frameHeight; ++maxHeight) {
            BufferedImage raster = ToolsAwt.createImage(image.getWidth(), height, image.getTransparency());
            ToolsAwt.fillBuffer(image, palette, raster, frameHeight, maxHeight, 0);
            rasters[maxHeight] = raster;
        }
        return rasters;
    }

    private static void fillBuffer(BufferedImage image, BufferedImage palette, BufferedImage raster, int tileHeight, int maxHeight, int ty) {
        int paletteColors = palette.getWidth();
        for (int y = 0; y < tileHeight; ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int ry = tileHeight - 1 - y + ty * tileHeight;
                int originalRgb = image.getRGB(x, ry);
                if (y <= maxHeight) {
                    int rasterRgb = ToolsAwt.findRaster(paletteColors, palette, originalRgb, 0);
                    raster.setRGB(x, ry, rasterRgb);
                    continue;
                }
                raster.setRGB(x, ry, originalRgb);
            }
        }
    }

    private static int findRaster(int paletteColors, BufferedImage palette, int originalRgb, int rasterIndex) {
        for (int p = 0; p < paletteColors; ++p) {
            if (palette.getRGB(p, 0) != originalRgb) continue;
            return palette.getRGB(p, rasterIndex + 1);
        }
        return originalRgb;
    }

    public static BufferedImage[] getRasterBufferOffset(BufferedImage image, BufferedImage palette, BufferedImage raster, int offsets) {
        int rasterHeight = raster.getHeight();
        BufferedImage[] rasters = new BufferedImage[rasterHeight];
        int width = image.getWidth();
        int height = image.getHeight();
        for (int rasterNumber = 0; rasterNumber < rasters.length; ++rasterNumber) {
            BufferedImage buffer = ToolsAwt.createImage(width, height, image.getTransparency());
            ToolsAwt.fillBufferOffset(image, palette, raster, buffer, offsets, rasterNumber);
            rasters[rasterNumber] = buffer;
        }
        return rasters;
    }

    private static void fillBufferOffset(BufferedImage image, BufferedImage palette, BufferedImage raster, BufferedImage buffer, int offsets, int rasterNumber) {
        int rasterHeight = raster.getHeight();
        int width = image.getWidth();
        int height = image.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int color = image.getRGB(x, y);
                if ((color >> 24 & 0xFF) == 0) continue;
                int currentOffset = (height - 1 - y) / offsets;
                int paletteOffset = ToolsAwt.findPaletteOffset(palette, color);
                int py = rasterHeight - 1 - rasterNumber - currentOffset * offsets - paletteOffset * 3;
                buffer.setRGB(x, y, raster.getRGB(0, UtilMath.clamp((int)py, (int)0, (int)(rasterHeight - 1))));
            }
        }
    }

    private static int findPaletteOffset(BufferedImage palette, int color) {
        for (int y = 0; y < palette.getHeight(); ++y) {
            if (palette.getRGB(0, y) != color) continue;
            return y;
        }
        return 0;
    }

    public static Cursor createHiddenCursor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(1, 1);
        BufferedImage c = ToolsAwt.createImage(Math.max(1, dim.width), Math.max(1, dim.height), 2);
        BufferedImage buffer = ToolsAwt.applyMask(c, Color.BLACK.getRGB());
        return toolkit.createCustomCursor(buffer, new Point(0, 0), "hiddenCursor");
    }

    public static void createBufferStrategy(Canvas component, GraphicsConfiguration conf) {
        try {
            component.createBufferStrategy(2, conf.getBufferCapabilities());
        }
        catch (AWTException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[0]);
            component.createBufferStrategy(1);
        }
    }

    public static void createBufferStrategy(Window component, GraphicsConfiguration conf) {
        try {
            component.createBufferStrategy(2, conf.getBufferCapabilities());
        }
        catch (AWTException exception) {
            Verbose.exception((Throwable)exception, (String[])new String[0]);
            component.createBufferStrategy(1);
        }
    }

    public static void optimizeGraphicsQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public static void optimizeGraphicsSpeed(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    private ToolsAwt() {
        throw new LionEngineException("Private constructor !");
    }
}

