/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.cardinality;

import com.bazaarvoice.jolt.cardinality.CardinalitySpec;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CardinalityLeafSpec
extends CardinalitySpec {
    private CardinalityRelationship cardinalityRelationship;

    public CardinalityLeafSpec(String rawKey, Object rhs) {
        super(rawKey);
        try {
            this.cardinalityRelationship = CardinalityRelationship.valueOf(rhs.toString());
        }
        catch (Exception e) {
            throw new SpecException("Invalid Cardinality type :" + rhs.toString(), e);
        }
    }

    @Override
    public boolean apply(String inputKey, Object input, WalkedPath walkedPath, Object parentContainer) {
        MatchedElement thisLevel = this.getMatch(inputKey, walkedPath);
        if (thisLevel == null) {
            return false;
        }
        this.performCardinalityAdjustment(inputKey, input, walkedPath, (Map)parentContainer, thisLevel);
        return true;
    }

    public Object applyToParentContainer(String inputKey, Object input, WalkedPath walkedPath, Object parentContainer) {
        MatchedElement thisLevel = this.getMatch(inputKey, walkedPath);
        if (thisLevel == null) {
            return null;
        }
        return this.performCardinalityAdjustment(inputKey, input, walkedPath, (Map)parentContainer, thisLevel);
    }

    private Object performCardinalityAdjustment(String inputKey, Object input, WalkedPath walkedPath, Map parentContainer, MatchedElement thisLevel) {
        walkedPath.add(input, thisLevel);
        List returnValue = null;
        if (this.cardinalityRelationship == CardinalityRelationship.MANY) {
            if (input instanceof List) {
                returnValue = input;
            } else if (input instanceof Map || input instanceof String || input instanceof Number || input instanceof Boolean) {
                Object one = parentContainer.remove(inputKey);
                ArrayList tempList = new ArrayList();
                tempList.add(one);
                returnValue = tempList;
            } else if (input == null) {
                returnValue = Collections.emptyList();
            }
            parentContainer.put(inputKey, returnValue);
        } else if (this.cardinalityRelationship == CardinalityRelationship.ONE && input instanceof List) {
            if (!((List)input).isEmpty()) {
                returnValue = ((List)input).get(0);
            }
            parentContainer.put(inputKey, returnValue);
        }
        walkedPath.removeLast();
        return returnValue;
    }

    private MatchedElement getMatch(String inputKey, WalkedPath walkedPath) {
        return this.pathElement.match(inputKey, walkedPath);
    }

    public static enum CardinalityRelationship {
        ONE,
        MANY;

    }
}

