/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.pathelement;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.pathelement.MatchablePathElement;
import com.bazaarvoice.jolt.common.tree.MatchedElement;
import com.bazaarvoice.jolt.common.tree.PathStep;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.shiftr.TransposeReader;
import com.bazaarvoice.jolt.utils.StringTools;

public class TransposePathElement
extends BasePathElement
implements MatchablePathElement,
EvaluatablePathElement {
    private final int upLevel;
    private final TransposeReader subPathReader;
    private final String canonicalForm;

    public static TransposePathElement parse(String key) {
        if (key == null || key.length() < 2) {
            throw new SpecException("'Transpose Input' key '@', can not be null or of length 1.  Offending key : " + key);
        }
        if ('@' != key.charAt(0)) {
            throw new SpecException("'Transpose Input' key must start with an '@'.  Offending key : " + key);
        }
        String meat = key.substring(1);
        if (meat.contains("@")) {
            throw new SpecException("@ pathElement can not contain a nested @. Was: " + meat);
        }
        if (meat.contains("*") || meat.contains("[]")) {
            throw new SpecException("'Transpose Input' can not contain expansion wildcards (* and []).  Offending key : " + key);
        }
        if (meat.startsWith("(")) {
            if (meat.endsWith(")")) {
                meat = meat.substring(1, meat.length() - 1);
            } else {
                throw new SpecException("@ path element that starts with '(' must have a matching ')'.  Offending key : " + key);
            }
        }
        return TransposePathElement.innerParse(key, meat);
    }

    private static TransposePathElement innerParse(String originalKey, String meat) {
        char first = meat.charAt(0);
        if (Character.isDigit(first)) {
            StringBuilder sb = new StringBuilder().append(first);
            for (int index = 1; index < meat.length(); ++index) {
                char c = meat.charAt(index);
                if (',' == c) {
                    int upLevel;
                    try {
                        upLevel = Integer.valueOf(sb.toString());
                    }
                    catch (NumberFormatException nfe) {
                        throw new SpecException("@ path element with non/mixed numeric key is not valid, key=" + originalKey);
                    }
                    return new TransposePathElement(originalKey, upLevel, meat.substring(index + 1));
                }
                if (!Character.isDigit(c)) {
                    throw new SpecException("@ path element with non/mixed numeric key is not valid, key=" + originalKey);
                }
                sb.append(c);
            }
            return new TransposePathElement(originalKey, Integer.valueOf(sb.toString()), null);
        }
        return new TransposePathElement(originalKey, 0, meat);
    }

    private TransposePathElement(String originalKey, int upLevel, String subPath) {
        super(originalKey);
        this.upLevel = upLevel;
        if (StringTools.isEmpty(subPath)) {
            this.subPathReader = null;
            this.canonicalForm = "@(" + upLevel + ",)";
        } else {
            this.subPathReader = new TransposeReader(subPath);
            this.canonicalForm = "@(" + upLevel + "," + this.subPathReader.getCanonicalForm() + ")";
        }
    }

    public Optional<Object> objectEvaluate(WalkedPath walkedPath) {
        PathStep pathStep = walkedPath.elementFromEnd(this.upLevel);
        if (pathStep == null) {
            return Optional.empty();
        }
        Object treeRef = pathStep.getTreeRef();
        if (this.subPathReader == null) {
            return Optional.of(treeRef);
        }
        return this.subPathReader.read(treeRef, walkedPath);
    }

    @Override
    public String evaluate(WalkedPath walkedPath) {
        Optional<Object> dataFromTranspose = this.objectEvaluate(walkedPath);
        if (dataFromTranspose.isPresent()) {
            Object data = dataFromTranspose.get();
            if (data instanceof Number) {
                int val = ((Number)data).intValue();
                return Integer.toString(val);
            }
            if (data instanceof Boolean) {
                return Boolean.toString((Boolean)data);
            }
            if (data == null || !(data instanceof String)) {
                return null;
            }
            return (String)data;
        }
        return null;
    }

    @Override
    public MatchedElement match(String dataKey, WalkedPath walkedPath) {
        return walkedPath.lastElement().getMatchedElement();
    }

    @Override
    public String getCanonicalForm() {
        return this.canonicalForm;
    }
}

