/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.common.tree;

import com.bazaarvoice.jolt.common.pathelement.BasePathElement;
import com.bazaarvoice.jolt.common.pathelement.EvaluatablePathElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MatchedElement
extends BasePathElement
implements EvaluatablePathElement {
    private final List<String> subKeys;
    private int hashCount = 0;

    public MatchedElement(String key) {
        super(key);
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(key);
        this.subKeys = Collections.unmodifiableList(keys);
    }

    public MatchedElement(String key, List<String> subKeys) {
        super(key);
        if (subKeys == null) {
            throw new IllegalArgumentException("MatchedElement for key:" + key + " got null list of subKeys");
        }
        ArrayList<String> keys = new ArrayList<String>(1 + subKeys.size());
        keys.add(key);
        keys.addAll(subKeys);
        this.subKeys = Collections.unmodifiableList(keys);
    }

    @Override
    public String evaluate(WalkedPath walkedPath) {
        return this.getRawKey();
    }

    @Override
    public String getCanonicalForm() {
        return this.getRawKey();
    }

    public String getSubKeyRef(int index) {
        if (index < 0 || index >= this.subKeys.size()) {
            throw new IndexOutOfBoundsException("MatchedElement " + this.subKeys + " cannot be indexed with index " + index);
        }
        return this.subKeys.get(index);
    }

    public int getSubKeyCount() {
        return this.subKeys.size();
    }

    public int getHashCount() {
        return this.hashCount;
    }

    public void incrementHashCount() {
        ++this.hashCount;
    }
}

