/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.removr.spec;

import com.bazaarvoice.jolt.common.pathelement.LiteralPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarAllPathElement;
import com.bazaarvoice.jolt.common.pathelement.StarPathElement;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.removr.spec.RemovrLeafSpec;
import com.bazaarvoice.jolt.removr.spec.RemovrSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RemovrCompositeSpec
extends RemovrSpec {
    private final List<RemovrSpec> allChildNodes;

    public RemovrCompositeSpec(String rawKey, Map<String, Object> spec) {
        super(rawKey);
        ArrayList<RemovrCompositeSpec> all = new ArrayList<RemovrCompositeSpec>();
        for (String rawLhsStr : spec.keySet()) {
            String[] keyStrings;
            Object rawRhs = spec.get(rawLhsStr);
            for (String keyString : keyStrings = rawLhsStr.split("\\|")) {
                RemovrSpec childSpec;
                if (rawRhs instanceof Map) {
                    childSpec = new RemovrCompositeSpec(keyString, (Map)rawRhs);
                } else if (rawRhs instanceof String && ((String)rawRhs).trim().length() == 0) {
                    childSpec = new RemovrLeafSpec(keyString);
                } else {
                    throw new SpecException("Invalid Removr spec RHS. Should be an empty string or Map");
                }
                all.add((RemovrCompositeSpec)childSpec);
            }
        }
        this.allChildNodes = Collections.unmodifiableList(all);
    }

    @Override
    public List<String> applyToMap(Map<String, Object> inputMap) {
        if (this.pathElement instanceof LiteralPathElement) {
            Object subInput = inputMap.get(this.pathElement.getRawKey());
            this.processChildren(this.allChildNodes, subInput);
        } else if (this.pathElement instanceof StarPathElement) {
            StarPathElement star = (StarPathElement)this.pathElement;
            for (Map.Entry<String, Object> entry : inputMap.entrySet()) {
                if (!star.stringMatch(entry.getKey())) continue;
                this.processChildren(this.allChildNodes, entry.getValue());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<Integer> applyToList(List<Object> inputList) {
        if (this.pathElement instanceof LiteralPathElement) {
            Integer pathElementInt = this.getNonNegativeIntegerFromLiteralPathElement();
            if (pathElementInt != null && pathElementInt < inputList.size()) {
                Object subObj = inputList.get(pathElementInt);
                this.processChildren(this.allChildNodes, subObj);
            }
        } else if (this.pathElement instanceof StarAllPathElement) {
            for (Object entry : inputList) {
                this.processChildren(this.allChildNodes, entry);
            }
        }
        return Collections.emptyList();
    }

    private void processChildren(List<RemovrSpec> children, Object subInput) {
        if (subInput != null) {
            if (subInput instanceof List) {
                List subList = (List)subInput;
                HashSet<Integer> indiciesToRemove = new HashSet<Integer>();
                for (RemovrSpec childSpec : children) {
                    indiciesToRemove.addAll(childSpec.applyToList(subList));
                }
                ArrayList uniqueIndiciesToRemove = new ArrayList(indiciesToRemove);
                Collections.sort(uniqueIndiciesToRemove, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o2.compareTo(o1);
                    }
                });
                Iterator i$ = uniqueIndiciesToRemove.iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    subList.remove(index);
                }
            } else if (subInput instanceof Map) {
                Map subInputMap = (Map)subInput;
                LinkedList<String> keysToRemove = new LinkedList<String>();
                for (RemovrSpec childSpec : children) {
                    keysToRemove.addAll(childSpec.applyToMap(subInputMap));
                }
                subInputMap.keySet().removeAll(keysToRemove);
            }
        }
    }
}

