/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr.traversal;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.traversr.Traversr;
import com.bazaarvoice.jolt.traversr.traversal.BaseTraversalStep;
import com.bazaarvoice.jolt.traversr.traversal.TraversalStep;
import java.util.ArrayList;
import java.util.List;

public class ArrayTraversalStep<DataType>
extends BaseTraversalStep<List<Object>, DataType> {
    public ArrayTraversalStep(Traversr traversr, TraversalStep child) {
        super(traversr, child);
    }

    @Override
    public Class getStepType() {
        return List.class;
    }

    @Override
    public List<Object> newContainer() {
        return new ArrayList<Object>();
    }

    @Override
    public Optional<DataType> get(List<Object> list, String key) {
        int arrayIndex = Integer.parseInt(key);
        if (arrayIndex < list.size()) {
            return Optional.of(list.get(arrayIndex));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DataType> remove(List<Object> list, String key) {
        int arrayIndex = Integer.parseInt(key);
        if (arrayIndex < list.size()) {
            return Optional.of(list.remove(arrayIndex));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DataType> overwriteSet(List<Object> list, String key, DataType data) {
        int arrayIndex = Integer.parseInt(key);
        ArrayTraversalStep.ensureArraySize(list, arrayIndex);
        list.set(arrayIndex, data);
        return Optional.of(data);
    }

    private static void ensureArraySize(List<Object> list, Integer upperIndex) {
        for (int sizing = list.size(); sizing <= upperIndex; ++sizing) {
            list.add(null);
        }
    }
}

