/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.modifier.function;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.common.PathEvaluatingTraversal;
import com.bazaarvoice.jolt.common.pathelement.PathElement;
import com.bazaarvoice.jolt.common.pathelement.TransposePathElement;
import com.bazaarvoice.jolt.common.tree.WalkedPath;
import com.bazaarvoice.jolt.exception.SpecException;
import com.bazaarvoice.jolt.modifier.function.Objects;
import java.util.Map;

public abstract class FunctionArg {
    public static FunctionArg forSelf(PathEvaluatingTraversal traversal) {
        return new SelfLookupArg(traversal);
    }

    public static FunctionArg forContext(PathEvaluatingTraversal traversal) {
        return new ContextLookupArg(traversal);
    }

    public static FunctionArg forLiteral(Object obj, boolean parseArg) {
        if (parseArg) {
            if (obj instanceof String) {
                String arg = (String)obj;
                if (arg.length() == 0) {
                    return new LiteralArg(null);
                }
                if (arg.startsWith("'") && arg.endsWith("'")) {
                    return new LiteralArg(arg.substring(1, arg.length() - 1));
                }
                if (arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("false")) {
                    return new LiteralArg(Boolean.parseBoolean(arg));
                }
                Optional<? extends Number> optional = Objects.toNumber(arg);
                if (optional.isPresent()) {
                    return new LiteralArg(optional.get());
                }
                return new LiteralArg(arg);
            }
            return new LiteralArg(obj);
        }
        return new LiteralArg(obj);
    }

    public abstract Optional<Object> evaluateArg(WalkedPath var1, Map<String, Object> var2);

    private static final class LiteralArg
    extends FunctionArg {
        private final Optional<Object> returnValue;

        private LiteralArg(Object object) {
            this.returnValue = Optional.of(object);
        }

        @Override
        public Optional<Object> evaluateArg(WalkedPath walkedPath, Map<String, Object> context) {
            return this.returnValue;
        }
    }

    private static final class ContextLookupArg
    extends FunctionArg {
        private final PathEvaluatingTraversal traversal;

        private ContextLookupArg(PathEvaluatingTraversal traversal) {
            this.traversal = traversal;
        }

        @Override
        public Optional<Object> evaluateArg(WalkedPath walkedPath, Map<String, Object> context) {
            return this.traversal.read(context, walkedPath);
        }
    }

    private static final class SelfLookupArg
    extends FunctionArg {
        private final TransposePathElement pathElement;

        private SelfLookupArg(PathEvaluatingTraversal traversal) {
            PathElement pathElement = traversal.get(traversal.size() - 1);
            if (!(pathElement instanceof TransposePathElement)) {
                throw new SpecException("Expected @ path element here");
            }
            this.pathElement = (TransposePathElement)pathElement;
        }

        @Override
        public Optional<Object> evaluateArg(WalkedPath walkedPath, Map<String, Object> context) {
            return this.pathElement.objectEvaluate(walkedPath);
        }
    }
}

