/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.jolt.traversr.traversal;

import com.bazaarvoice.jolt.common.Optional;
import com.bazaarvoice.jolt.traversr.Traversr;
import com.bazaarvoice.jolt.traversr.traversal.TraversalStep;
import java.util.Iterator;

public abstract class BaseTraversalStep<StepType, DataType>
implements TraversalStep<StepType, DataType> {
    protected final TraversalStep child;
    protected final Traversr traversr;

    public BaseTraversalStep(Traversr traversr, TraversalStep child) {
        this.traversr = traversr;
        this.child = child;
    }

    @Override
    public TraversalStep getChild() {
        return this.child;
    }

    @Override
    public final Optional<DataType> traverse(StepType tree, TraversalStep.Operation op, Iterator<String> keys, DataType data) {
        if (tree == null) {
            return Optional.empty();
        }
        if (this.getStepType().isAssignableFrom(tree.getClass())) {
            String key = keys.next();
            if (this.child == null) {
                switch (op) {
                    case GET: {
                        return this.get(tree, key);
                    }
                    case SET: {
                        return this.traversr.handleFinalSet(this, tree, key, data);
                    }
                    case REMOVE: {
                        return this.remove(tree, key);
                    }
                }
                throw new IllegalStateException("Invalid op:" + op.toString());
            }
            Optional optSub = this.traversr.handleIntermediateGet(this, tree, key, op);
            if (optSub.isPresent()) {
                return this.child.traverse(optSub.get(), op, keys, data);
            }
        }
        return Optional.empty();
    }
}

