/*
 * Decompiled with CFR 0.152.
 */
package com.bazaarvoice.maven.plugin.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class ProcessHealthCondition {
    private static final int SECONDS_BETWEEN_CHECKS = 1;

    private ProcessHealthCondition() {
    }

    public static void waitSecondsUntilHealthy(String healthCheckUrl, int timeoutInSeconds) {
        if (healthCheckUrl == null) {
            ProcessHealthCondition.sleep(timeoutInSeconds);
            return;
        }
        long start = System.currentTimeMillis();
        URL url = ProcessHealthCondition.url(healthCheckUrl);
        while ((System.currentTimeMillis() - start) / 1000L < (long)timeoutInSeconds) {
            ProcessHealthCondition.internalSleep();
            if (!ProcessHealthCondition.is200(url)) continue;
            return;
        }
        throw new RuntimeException("Process was not healthy even after " + timeoutInSeconds + " seconds");
    }

    private static boolean is200(URL url) {
        try {
            int code = ProcessHealthCondition.getResponseCode(url);
            return 200 <= code && code < 300;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getResponseCode(URL url) {
        int n;
        InputStream in = null;
        try {
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setRequestMethod("GET");
            http.connect();
            in = http.getInputStream();
            n = http.getResponseCode();
        }
        catch (ProtocolException e) {
            try {
                throw new RuntimeException(e);
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                ProcessHealthCondition.closeQuietly(in);
                throw throwable;
            }
        }
        ProcessHealthCondition.closeQuietly(in);
        return n;
    }

    private static URL url(String spec) {
        try {
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void internalSleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void sleep(int seconds) {
        try {
            Thread.sleep(seconds * 1000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void closeQuietly(Closeable out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

