/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.dropwizard.redis;

import com.bendb.dropwizard.redis.JedisConfiguration;
import com.bendb.dropwizard.redis.JedisHealthCheck;
import com.bendb.dropwizard.redis.jersey.JedisPoolBinder;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.health.HealthCheck;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import redis.clients.jedis.JedisPool;

public abstract class JedisBundle<C extends Configuration>
implements ConfiguredBundle<C>,
JedisConfiguration<C> {
    private JedisPool pool;

    public JedisPool getPool() {
        return this.pool;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(C configuration, Environment environment) throws Exception {
        this.pool = this.getJedisFactory((Configuration)configuration).build(environment);
        environment.healthChecks().register("redis", (HealthCheck)new JedisHealthCheck(this.pool));
        environment.jersey().register((Object)new JedisPoolBinder(this.pool));
        environment.metrics().register("redis.connection.idle", (Metric)((Gauge)() -> this.pool.getNumIdle()));
        environment.metrics().register("redis.connection.active", (Metric)((Gauge)() -> this.pool.getNumActive()));
        environment.metrics().register("redis.connection.wait", (Metric)((Gauge)() -> this.pool.getNumWaiters()));
    }
}

