/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.dropwizard.redis;

import com.bendb.dropwizard.redis.JedisPoolManager;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.net.HostAndPort;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Environment;
import javax.validation.constraints.NotNull;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class JedisFactory {
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_MAX_TOTAL = 1024;
    @JsonProperty
    @NotNull
    private HostAndPort endpoint;
    @JsonProperty
    private String password;
    @JsonProperty
    private int minIdle = 0;
    @JsonProperty
    private int maxIdle = 0;
    @JsonProperty
    private int maxTotal = 1024;

    public HostAndPort getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(HostAndPort endpoint) {
        this.endpoint = endpoint;
    }

    public String getHost() {
        return this.endpoint.getHostText();
    }

    public int getPort() {
        return this.endpoint.getPortOrDefault(6379);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public JedisPool build(Environment environment) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMinIdle(this.getMinIdle());
        poolConfig.setMaxIdle(this.getMaxIdle());
        poolConfig.setMaxTotal(this.getMaxTotal());
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)poolConfig, this.getHost(), this.getPort(), 2000, this.getPassword());
        environment.lifecycle().manage((Managed)new JedisPoolManager(pool));
        return pool;
    }
}

