/*
 * Decompiled with CFR 0.152.
 */
package com.bendb.dropwizard.redis;

import com.codahale.metrics.health.HealthCheck;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class JedisHealthCheck
extends HealthCheck {
    private final JedisPool pool;

    public JedisHealthCheck(JedisPool pool) {
        this.pool = pool;
    }

    protected HealthCheck.Result check() throws Exception {
        try (Jedis jedis = this.pool.getResource();){
            String pong = jedis.ping();
            if ("PONG".equals(pong)) {
                HealthCheck.Result result = HealthCheck.Result.healthy();
                return result;
            }
        }
        return HealthCheck.Result.unhealthy((String)"Could not ping redis");
    }
}

