/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.gradle;

import asset.pipeline.AssetCompiler;
import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.AssetSpecLoader;
import asset.pipeline.fs.AssetResolver;
import asset.pipeline.fs.FileSystemAssetResolver;
import asset.pipeline.fs.JarAssetResolver;
import asset.pipeline.gradle.AssetPipelineExtension;
import asset.pipeline.gradle.AssetPipelinePlugin;
import asset.pipeline.gradle.GradleEventListener;
import groovy.lang.Closure;
import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.DynamicObject;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.internal.Factory;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.StandardOutputCapture;

public class AssetCompile
extends DefaultTask
implements GroovyObject {
    @Delegate
    private AssetPipelineExtension pipelineExtension;
    private FileCollection classpath;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1439427255109;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AssetCompile() {
        MetaClass metaClass;
        AssetPipelineExtension assetPipelineExtension;
        this.pipelineExtension = assetPipelineExtension = new AssetPipelineExtension();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @OutputDirectory
    public File getDestinationDir() {
        return (File)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)this.pipelineExtension.getCompileDir()) ? new File(this.pipelineExtension.getCompileDir()) : null), File.class);
    }

    public void setDestinationDir(File dir) {
        this.pipelineExtension.setCompileDir(dir.getAbsolutePath());
    }

    @Input
    public File getAssetsDir() {
        String path = this.pipelineExtension.getAssetsPath();
        return (File)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)path) ? new File(path) : null), File.class);
    }

    public void setAssetsDir(File assetsDir) {
        this.pipelineExtension.setAssetsPath(assetsDir.getAbsolutePath());
    }

    @Input
    @Optional
    public boolean getEnableDigests() {
        return this.pipelineExtension.isEnableDigests();
    }

    public void setEnableDigests(boolean enableDigests) {
        this.pipelineExtension.setEnableDigests(enableDigests);
    }

    @Input
    @Optional
    public boolean getEnableGzip() {
        return this.pipelineExtension.isEnableGzip();
    }

    public void setEnableGzip(boolean enableGzip) {
        this.pipelineExtension.setEnableGzip(enableGzip);
    }

    @Input
    @Optional
    public boolean getEnableSourceMaps() {
        return this.pipelineExtension.isEnableSourceMaps();
    }

    public void setEnableSourceMaps(boolean enableGzip) {
        this.pipelineExtension.setEnableSourceMaps(this.getEnableSourceMaps());
    }

    @Input
    @Optional
    public boolean getSkipNonDigests() {
        return this.pipelineExtension.isSkipNonDigests();
    }

    public void setSkipNonDigests(boolean skipNonDigests) {
        this.pipelineExtension.setSkipNonDigests(skipNonDigests);
    }

    @Input
    @Optional
    public boolean getMinifyJs() {
        return this.pipelineExtension.isMinifyJs();
    }

    public void setMinifyJs(boolean minifyJs) {
        this.pipelineExtension.setMinifyJs(minifyJs);
    }

    @Input
    @Optional
    public boolean getMinifyCss() {
        return this.pipelineExtension.isMinifyCss();
    }

    @Input
    @Optional
    public Map getConfigOptions() {
        return this.pipelineExtension.getConfigOptions();
    }

    public void setConfig(Map configOptions) {
        this.pipelineExtension.setConfigOptions(configOptions);
    }

    public void setMinifyCss(boolean minifyCss) {
        this.pipelineExtension.setMinifyCss(minifyCss);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InputFiles
    @Optional
    public FileCollection getClasspath() {
        try {
            FileCollection runtimeFiles = (FileCollection)ScriptBytecodeAdapter.asType((Object)this.getProject().getConfigurations().getByName("runtime"), FileCollection.class);
            FileCollection providedFiles = (FileCollection)ScriptBytecodeAdapter.asType((Object)this.getProject().getConfigurations().getByName("provided"), FileCollection.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)providedFiles)) return runtimeFiles;
            return runtimeFiles.plus(providedFiles);
        }
        catch (Exception e) {
            return (FileCollection)ScriptBytecodeAdapter.asType(null, FileCollection.class);
        }
    }

    @InputFiles
    public FileTree getSource() {
        FileTree src = this.getProject().files(new Object[]{this.getAssetsDir()}).getAsFileTree();
        return src;
    }

    @TaskAction
    public void compile() {
        CallSite[] callSiteArray = AssetCompile.$getCallSiteArray();
        Object object = callSiteArray[0].callGroovyObjectGetProperty((Object)this);
        ScriptBytecodeAdapter.setProperty((Object)object, null, AssetPipelineConfigHolder.class, (String)"config");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[1].callCurrent((GroovyObject)this);
        } else {
            this.registerResolvers();
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[2].callCurrent((GroovyObject)this);
        } else {
            this.loadAssetSpecifications();
        }
        Object assetCompiler = callSiteArray[3].callConstructor(AssetCompiler.class, callSiteArray[4].call((Object)this.pipelineExtension), callSiteArray[5].callConstructor(GradleEventListener.class));
        Object object2 = callSiteArray[6].callGroovyObjectGetProperty((Object)this.pipelineExtension);
        ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)callSiteArray[7].callGetProperty(assetCompiler), (String)"default");
        Object object3 = callSiteArray[8].callGroovyObjectGetProperty((Object)this.pipelineExtension);
        ScriptBytecodeAdapter.setProperty((Object)object3, null, (Object)callSiteArray[9].callGetProperty(assetCompiler), (String)"default");
        callSiteArray[10].call(assetCompiler);
    }

    public void registerResolvers() {
        FileSystemAssetResolver mainFileResolver = new FileSystemAssetResolver("application", this.getAssetsDir().getCanonicalPath());
        AssetPipelineConfigHolder.registerResolver((AssetResolver)mainFileResolver);
        DefaultGroovyMethods.each(this.pipelineExtension.getResolvers(), (Closure)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(String path) {
                File resolverFile = ((Project)this.getProperty("project")).file((Object)path);
                boolean isJarFile = resolverFile.exists() && resolverFile.isFile() && resolverFile.getName().endsWith(".jar");
                boolean isAssetFolder = resolverFile.exists() && resolverFile.isDirectory();
                if (isJarFile) {
                    ((AssetCompile)((Object)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), AssetCompile.class))).registerJarResolvers(resolverFile);
                    return null;
                }
                if (isAssetFolder) {
                    FileSystemAssetResolver fileResolver = new FileSystemAssetResolver(path, path, false);
                    return AssetPipelineConfigHolder.registerResolver((AssetResolver)fileResolver);
                }
                return null;
            }

            public Object call(String path) {
                return this.doCall(path);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _registerResolvers_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _registerResolvers_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_registerResolvers_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _registerResolvers_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        FileCollection fileCollection = this.getClasspath();
        Set set = fileCollection != null ? fileCollection.getFiles() : null;
        Iterable iterable = set != null ? DefaultGroovyMethods.each((Iterable)set, (Closure)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Object it) {
                ((AssetCompile)((Object)ScriptBytecodeAdapter.castToType((Object)this.getProperty("thisObject"), AssetCompile.class))).registerJarResolvers((File)ScriptBytecodeAdapter.castToType((Object)it, File.class));
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _registerResolvers_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _registerResolvers_closure2.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_registerResolvers_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _registerResolvers_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
    }

    public void registerJarResolvers(File jarFile) {
        if (jarFile.exists()) {
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/assets"));
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/static"));
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new JarAssetResolver(jarFile.getName(), jarFile.getCanonicalPath(), "META-INF/resources"));
        }
    }

    public void loadAssetSpecifications() {
        Configuration configuration = this.getProject().getConfigurations().getByName(AssetPipelinePlugin.getASSET_CONFIGURATION_NAME());
        Set processorFiles = configuration != null ? configuration.getFiles() : null;
        if (DefaultTypeTransformation.booleanUnbox((Object)processorFiles)) {
            URL[] urls = (URL[])ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.collect((Collection)processorFiles, (Closure)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public Object doCall(Object it) {
                    return ((File)it).toURI().toURL();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _loadAssetSpecifications_closure3.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                }

                static {
                    _loadAssetSpecifications_closure3.__$swapInit();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[]{};
                    return new CallSiteArray(_loadAssetSpecifications_closure3.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _loadAssetSpecifications_closure3.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            }), URL[].class);
            URLClassLoader classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
            AssetSpecLoader.loadSpecifications((ClassLoader)classLoader);
        } else {
            AssetSpecLoader.loadSpecifications();
        }
    }

    public void from(String resolverPath) {
        this.pipelineExtension.from(resolverPath);
    }

    public Map toMap() {
        return this.pipelineExtension.toMap();
    }

    public String getCompileDir() {
        return this.pipelineExtension.getCompileDir();
    }

    public void setCompileDir(String value) {
        this.pipelineExtension.setCompileDir(value);
    }

    public String getAssetsPath() {
        return this.pipelineExtension.getAssetsPath();
    }

    public void setAssetsPath(String value) {
        this.pipelineExtension.setAssetsPath(value);
    }

    public Map getMinifyOptions() {
        return this.pipelineExtension.getMinifyOptions();
    }

    public void setMinifyOptions(Map value) {
        this.pipelineExtension.setMinifyOptions(value);
    }

    public void setConfigOptions(Map value) {
        this.pipelineExtension.setConfigOptions(value);
    }

    public List getExcludesGzip() {
        return this.pipelineExtension.getExcludesGzip();
    }

    public void setExcludesGzip(List value) {
        this.pipelineExtension.setExcludesGzip(value);
    }

    public List getExcludes() {
        return this.pipelineExtension.getExcludes();
    }

    public void setExcludes(List value) {
        this.pipelineExtension.setExcludes(value);
    }

    public List getIncludes() {
        return this.pipelineExtension.getIncludes();
    }

    public void setIncludes(List value) {
        this.pipelineExtension.setIncludes(value);
    }

    public List getResolvers() {
        return this.pipelineExtension.getResolvers();
    }

    public void setResolvers(List value) {
        this.pipelineExtension.setResolvers(value);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AssetCompile.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, AssetCompile.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(AssetCompile.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AssetCompile.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        AssetCompile.__$swapInit();
        Long l = 0L;
        __timeStamp__239_neverHappen1439427255109 = l;
        Long l2 = 1439427255109L;
        __timeStamp = l2;
    }

    public AssetPipelineExtension getPipelineExtension() {
        return this.pipelineExtension;
    }

    public void setPipelineExtension(AssetPipelineExtension assetPipelineExtension) {
        this.pipelineExtension = assetPipelineExtension;
    }

    public /* synthetic */ Task super$2$finalizedBy(Object[] objectArray) {
        return super.finalizedBy(objectArray);
    }

    public /* synthetic */ List super$2$getActions() {
        return super.getActions();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ ExtensionContainer super$2$getExtensions() {
        return super.getExtensions();
    }

    public /* synthetic */ boolean super$2$getDidWork() {
        return super.getDidWork();
    }

    public /* synthetic */ List super$2$getTaskActions() {
        return super.getTaskActions();
    }

    public /* synthetic */ TaskExecuter super$2$getExecuter() {
        return super.getExecuter();
    }

    public /* synthetic */ Task super$2$doLast(Closure closure) {
        return super.doLast(closure);
    }

    public /* synthetic */ void super$2$setDependsOn(Iterable iterable) {
        super.setDependsOn(iterable);
    }

    public /* synthetic */ Convention super$2$getConvention() {
        return super.getConvention();
    }

    public /* synthetic */ AntBuilder super$2$getAnt() {
        return super.getAnt();
    }

    public /* synthetic */ void super$2$setDidWork(boolean bl) {
        super.setDidWork(bl);
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ Logger super$2$getLogger() {
        return super.getLogger();
    }

    public /* synthetic */ Project super$2$getProject() {
        return super.getProject();
    }

    public /* synthetic */ List super$2$getValidators() {
        return super.getValidators();
    }

    public /* synthetic */ ServiceRegistry super$2$getServices() {
        return super.getServices();
    }

    public /* synthetic */ void super$2$setFinalizedBy(Iterable iterable) {
        super.setFinalizedBy(iterable);
    }

    public /* synthetic */ void super$2$setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ Task super$2$configure(Closure closure) {
        return super.configure(closure);
    }

    public /* synthetic */ Task super$2$doFirst(Action action) {
        return super.doFirst(action);
    }

    public /* synthetic */ void super$2$setExecuter(TaskExecuter taskExecuter) {
        super.setExecuter(taskExecuter);
    }

    public /* synthetic */ TaskOutputsInternal super$2$getOutputs() {
        return super.getOutputs();
    }

    public /* synthetic */ String super$2$toString() {
        return super.toString();
    }

    public /* synthetic */ TaskDependency super$2$shouldRunAfter(Object[] objectArray) {
        return super.shouldRunAfter(objectArray);
    }

    public /* synthetic */ void super$2$onlyIf(Closure closure) {
        super.onlyIf(closure);
    }

    public /* synthetic */ boolean super$2$dependsOnTaskDidWork() {
        return super.dependsOnTaskDidWork();
    }

    public /* synthetic */ boolean super$2$isEnabled() {
        return super.isEnabled();
    }

    public /* synthetic */ void super$2$setOnlyIf(Spec spec) {
        super.setOnlyIf(spec);
    }

    public /* synthetic */ TaskDependency super$2$getShouldRunAfter() {
        return super.getShouldRunAfter();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$2$isHasCustomActions() {
        return super.isHasCustomActions();
    }

    public /* synthetic */ void super$2$executeWithoutThrowingTaskFailure() {
        super.executeWithoutThrowingTaskFailure();
    }

    public /* synthetic */ DynamicObject super$2$getAsDynamicObject() {
        return super.getAsDynamicObject();
    }

    public /* synthetic */ void super$2$setProject(Project project) {
        super.setProject(project);
    }

    public /* synthetic */ String super$2$getPath() {
        return super.getPath();
    }

    public /* synthetic */ void super$2$addValidator(TaskValidator taskValidator) {
        super.addValidator(taskValidator);
    }

    public /* synthetic */ Task super$2$doLast(Action action) {
        return super.doLast(action);
    }

    public /* synthetic */ void super$2$setShouldRunAfter(Iterable iterable) {
        super.setShouldRunAfter(iterable);
    }

    public /* synthetic */ boolean super$2$getImpliesSubProjects() {
        return super.getImpliesSubProjects();
    }

    public /* synthetic */ void super$2$setImpliesSubProjects(boolean bl) {
        super.setImpliesSubProjects(bl);
    }

    public /* synthetic */ Task super$2$deleteAllActions() {
        return super.deleteAllActions();
    }

    public /* synthetic */ void super$2$setOnlyIf(Closure closure) {
        super.setOnlyIf(closure);
    }

    public /* synthetic */ TaskDependency super$2$getMustRunAfter() {
        return super.getMustRunAfter();
    }

    public /* synthetic */ boolean super$2$getEnabled() {
        return super.getEnabled();
    }

    public /* synthetic */ LoggingManagerInternal super$2$getLogging() {
        return super.getLogging();
    }

    public /* synthetic */ TaskDependencyInternal super$2$getTaskDependencies() {
        return super.getTaskDependencies();
    }

    public /* synthetic */ File super$2$getTemporaryDir() {
        return super.getTemporaryDir();
    }

    public /* synthetic */ void super$2$onlyIf(Spec spec) {
        super.onlyIf(spec);
    }

    public /* synthetic */ Task super$2$leftShift(Closure closure) {
        return super.leftShift(closure);
    }

    public /* synthetic */ Spec super$2$getOnlyIf() {
        return super.getOnlyIf();
    }

    public /* synthetic */ Task super$2$doFirst(Closure closure) {
        return super.doFirst(closure);
    }

    public /* synthetic */ void super$2$setName(String string) {
        super.setName(string);
    }

    public /* synthetic */ Factory super$2$getTemporaryDirFactory() {
        return super.getTemporaryDirFactory();
    }

    public /* synthetic */ void super$2$setActions(List list) {
        super.setActions(list);
    }

    public /* synthetic */ Task super$2$mustRunAfter(Object[] objectArray) {
        return super.mustRunAfter(objectArray);
    }

    public /* synthetic */ void super$2$execute() {
        super.execute();
    }

    public /* synthetic */ StandardOutputCapture super$2$getStandardOutputCapture() {
        return super.getStandardOutputCapture();
    }

    public /* synthetic */ void super$2$prependParallelSafeAction(Action action) {
        super.prependParallelSafeAction(action);
    }

    public /* synthetic */ void super$2$setDescription(String string) {
        super.setDescription(string);
    }

    public /* synthetic */ void super$2$setGroup(String string) {
        super.setGroup(string);
    }

    public /* synthetic */ TaskInputs super$2$getInputs() {
        return super.getInputs();
    }

    public /* synthetic */ Object super$2$property(String string) {
        return super.property(string);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ String super$2$getDescription() {
        return super.getDescription();
    }

    public /* synthetic */ void super$2$setMustRunAfter(Iterable iterable) {
        super.setMustRunAfter(iterable);
    }

    public /* synthetic */ boolean super$2$hasProperty(String string) {
        return super.hasProperty(string);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ TaskDependency super$2$getFinalizedBy() {
        return super.getFinalizedBy();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ int super$2$compareTo(Task task) {
        return super.compareTo(task);
    }

    public /* synthetic */ Task super$2$dependsOn(Object[] objectArray) {
        return super.dependsOn(objectArray);
    }

    public /* synthetic */ TaskStateInternal super$2$getState() {
        return super.getState();
    }

    public /* synthetic */ String super$2$getName() {
        return super.getName();
    }

    public /* synthetic */ Set super$2$getDependsOn() {
        return super.getDependsOn();
    }

    public /* synthetic */ void super$2$setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public /* synthetic */ void super$2$appendParallelSafeAction(Action action) {
        super.appendParallelSafeAction(action);
    }

    public /* synthetic */ String super$2$getGroup() {
        return super.getGroup();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "configOptions";
        stringArray[1] = "registerResolvers";
        stringArray[2] = "loadAssetSpecifications";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "toMap";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "excludes";
        stringArray[7] = "excludeRules";
        stringArray[8] = "includes";
        stringArray[9] = "includeRules";
        stringArray[10] = "compile";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[11];
        AssetCompile.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AssetCompile.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AssetCompile.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

