/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phone.home;

import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.phone.home.PhoneHomeInfo;
import com.blackducksoftware.integration.phone.home.PropertiesLoader;
import com.blackducksoftware.integration.phone.home.enums.BlackDuckName;
import com.blackducksoftware.integration.phone.home.enums.PhoneHomeSource;
import com.blackducksoftware.integration.phone.home.enums.ThirdPartyName;
import com.blackducksoftware.integration.phone.home.exception.PhoneHomeArgumentException;
import com.blackducksoftware.integration.phone.home.exception.PhoneHomeConnectionException;
import com.blackducksoftware.integration.phone.home.exception.PhoneHomeException;
import com.blackducksoftware.integration.phone.home.util.OkAuthenticator;
import com.blackducksoftware.integration.util.proxy.ProxyUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;

public class PhoneHomeClient {
    private final IntLogger logger;
    private final OkHttpClient.Builder builder = new OkHttpClient.Builder();
    private OkHttpClient client;
    private int timeout = 300;

    public PhoneHomeClient(IntLogger logger) {
        this.logger = logger;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setProxyProperties(String proxyHost, int proxyPort, String proxyUser, String decryptedProxyPassword, String ignoredProxyHost) throws PhoneHomeArgumentException {
        if (StringUtils.isNotBlank((CharSequence)proxyHost) && proxyPort > 0) {
            boolean shouldUseProxy = true;
            if (StringUtils.isNotBlank((CharSequence)ignoredProxyHost)) {
                URL targetUrl;
                PropertiesLoader propertiesLoader = new PropertiesLoader(this.logger);
                try {
                    targetUrl = new URL(propertiesLoader.createTargetUrl("config.properties"));
                }
                catch (Exception e) {
                    throw new PhoneHomeArgumentException(e.getMessage(), e);
                }
                List ignoredProxyHostPatterns = ProxyUtil.getIgnoredProxyHostPatterns((String)ignoredProxyHost);
                boolean bl = shouldUseProxy = !ProxyUtil.shouldIgnoreHost((String)targetUrl.getHost(), (List)ignoredProxyHostPatterns);
            }
            if (shouldUseProxy) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
                this.builder.proxy(proxy);
                if (StringUtils.isNotBlank((CharSequence)proxyUser) && StringUtils.isNotBlank((CharSequence)decryptedProxyPassword)) {
                    this.builder.proxyAuthenticator((Authenticator)new OkAuthenticator(proxyUser, decryptedProxyPassword));
                }
            }
        }
    }

    private void createClient() {
        this.builder.connectTimeout((long)this.timeout, TimeUnit.SECONDS);
        this.builder.writeTimeout((long)this.timeout, TimeUnit.SECONDS);
        this.builder.readTimeout((long)this.timeout, TimeUnit.SECONDS);
        this.client = this.builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callHome(PhoneHomeInfo info, String targetUrl) throws PhoneHomeException {
        if (info == null) {
            throw new PhoneHomeArgumentException("Could not find the information needed for the phone home.");
        }
        if (StringUtils.isBlank((CharSequence)targetUrl)) {
            throw new PhoneHomeArgumentException("The targetURL for the phone home was not provided.");
        }
        this.createClient();
        HttpUrl httpUrl = HttpUrl.parse((String)targetUrl).newBuilder().build();
        Gson gson = new GsonBuilder().create();
        String json = gson.toJson((Object)info);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)json);
        Request request = new Request.Builder().url(httpUrl).post(body).build();
        try (Response response = null;){
            try {
                response = this.client.newCall(request).execute();
            }
            catch (IOException e) {
                throw new PhoneHomeConnectionException(e.getMessage(), e);
            }
            if (!response.isSuccessful()) {
                throw new PhoneHomeConnectionException(response.message());
            }
        }
    }

    public void callHomeIntegrations(String regId, String hostName, String blackDuckName, String blackDuckVersion, String thirdPartyName, String thirdPartyVersion, String pluginVersion) throws PhoneHomeException {
        this.callHomeIntegrations(regId, hostName, blackDuckName, blackDuckVersion, thirdPartyName, thirdPartyVersion, pluginVersion, PhoneHomeSource.INTEGRATIONS, "config.properties");
    }

    public void callHomeIntegrations(String regId, String hostName, BlackDuckName blackDuckName, String blackDuckVersion, ThirdPartyName thirdPartyName, String thirdPartyVersion, String pluginVersion) throws PhoneHomeException {
        this.callHomeIntegrations(regId, hostName, blackDuckName.getName(), blackDuckVersion, thirdPartyName.getName(), thirdPartyVersion, pluginVersion, PhoneHomeSource.INTEGRATIONS, "config.properties");
    }

    public void callHomeIntegrations(String regId, String hostName, String blackDuckName, String blackDuckVersion, String thirdPartyName, String thirdPartyVersion, String pluginVersion, PhoneHomeSource source, String propertiesPath) throws PhoneHomeException {
        String targetUrl;
        this.validateIntegrationPhoneHome(regId, hostName, blackDuckName, blackDuckVersion, thirdPartyName, thirdPartyVersion, pluginVersion);
        PropertiesLoader propertiesLoader = new PropertiesLoader(this.logger);
        try {
            targetUrl = propertiesLoader.createTargetUrl(propertiesPath);
        }
        catch (Exception e) {
            throw new PhoneHomeArgumentException(e.getMessage(), e);
        }
        this.logger.debug("Integrations phone-home URL: " + targetUrl);
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("blackDuckName", blackDuckName);
        infoMap.put("blackDuckVersion", blackDuckVersion);
        infoMap.put("thirdPartyName", thirdPartyName);
        infoMap.put("thirdPartyVersion", thirdPartyVersion);
        infoMap.put("pluginVersion", pluginVersion);
        String hubIdentifier = null;
        if (regId != null) {
            hubIdentifier = regId;
        } else if (hostName != null) {
            hubIdentifier = this.md5Hash(hostName);
        }
        PhoneHomeInfo info = new PhoneHomeInfo(hubIdentifier, source, infoMap);
        this.callHome(info, targetUrl);
    }

    private void validateIntegrationPhoneHome(String regId, String hostName, String blackDuckName, String blackDuckVersion, String thirdPartyName, String thirdPartyVersion, String pluginVersion) throws PhoneHomeArgumentException {
        if (StringUtils.isBlank((CharSequence)regId) && StringUtils.isBlank((CharSequence)hostName)) {
            throw new PhoneHomeArgumentException("No identifier of the Hub server was provided for the phone home.");
        }
        if (StringUtils.isBlank((CharSequence)blackDuckName)) {
            throw new PhoneHomeArgumentException("The Black Duck product name was not provided for the phone home.");
        }
        if (StringUtils.isBlank((CharSequence)blackDuckVersion)) {
            throw new PhoneHomeArgumentException(String.format("The version of %s was not provided for the phone home.", blackDuckName));
        }
        if (StringUtils.isBlank((CharSequence)thirdPartyName)) {
            throw new PhoneHomeArgumentException("The third party name was not provided for the phone home.");
        }
        if (StringUtils.isBlank((CharSequence)thirdPartyVersion)) {
            throw new PhoneHomeArgumentException(String.format("The version of %s was not provided for the phone home.", thirdPartyName));
        }
        if (StringUtils.isBlank((CharSequence)pluginVersion)) {
            throw new PhoneHomeArgumentException("The plugin version was not provided for the phone home.");
        }
    }

    private String md5Hash(String string) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hashedBytes = md.digest(string.getBytes("UTF-8"));
            return DigestUtils.md5Hex((byte[])hashedBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

