/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phone.home;

import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.phone.home.exception.PropertiesLoaderException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class PropertiesLoader {
    private final IntLogger logger;

    public PropertiesLoader(IntLogger logger) {
        this.logger = logger;
    }

    public String createTargetUrl(String propertiesFileName) throws IOException, PropertiesLoaderException {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
        if (inputStream == null) {
            throw new PropertiesLoaderException("Unable to get find resource: " + propertiesFileName);
        }
        properties.load(inputStream);
        inputStream.close();
        StringBuilder target = new StringBuilder();
        target.append(properties.getProperty("targetUrl"));
        String targetPort = properties.getProperty("targetPort");
        if (targetPort != null && targetPort.trim().length() > 0) {
            target.append(":" + targetPort.trim());
        }
        target.append("/");
        String targetExt = properties.getProperty("targetExt");
        if (targetExt != null && targetExt.trim().length() > 0) {
            target.append(targetExt.trim());
        }
        this.logger.debug("Target URL: " + target.toString());
        return target.toString();
    }
}

