/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phone.home.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.commons.lang3.StringUtils;

public class AuthenticatorUtil {
    public static void resetAuthenticator() {
        Authenticator.setDefault(null);
        AuthenticatorUtil.attemptResetProxyCache();
    }

    public static void setAuthenticator(final String proxyUser, final String proxyPassword) {
        if (!StringUtils.isBlank((CharSequence)proxyUser) && !StringUtils.isBlank((CharSequence)proxyPassword)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                        return new PasswordAuthentication(proxyUser, proxyPassword.toCharArray());
                    }
                    return null;
                }
            });
        }
    }

    private static void attemptResetProxyCache() {
        try {
            Class<?> sunAuthCacheImpl;
            Class<?> sunAuthCache;
            Class<?> sunAuthCacheValue;
            try {
                sunAuthCacheValue = Class.forName("sun.net.www.protocol.http.AuthCacheValue");
                sunAuthCache = Class.forName("sun.net.www.protocol.http.AuthCache");
                sunAuthCacheImpl = Class.forName("sun.net.www.protocol.http.AuthCacheImpl");
            }
            catch (Exception e) {
                return;
            }
            Method m = sunAuthCacheValue.getDeclaredMethod("setAuthCache", sunAuthCache);
            Constructor<?> authCacheImplConstr = sunAuthCacheImpl.getConstructor(new Class[0]);
            Object authCachImp = authCacheImplConstr.newInstance(new Object[0]);
            m.invoke(null, authCachImp);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
    }
}

