/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phone.home.util;

import java.io.IOException;
import java.util.List;
import okhttp3.Authenticator;
import okhttp3.Challenge;
import okhttp3.Credentials;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class OkAuthenticator
implements Authenticator {
    public static final String PROXY_AUTH = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    public static final String WWW_AUTH = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    private final String username;
    private final String password;
    private boolean proxy;
    private boolean basicAuth;

    public OkAuthenticator(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Request authenticate(Route route, Response response) throws IOException {
        if (route.proxy() != null) {
            this.setProxy(true);
        }
        this.checkAuthScheme(response);
        if (this.isBasicAuth()) {
            return this.authenticateBasic(response);
        }
        return null;
    }

    private void checkAuthScheme(Response response) {
        List challenges = response.challenges();
        for (Challenge challenge : challenges) {
            if (!"Basic".equalsIgnoreCase(challenge.scheme())) continue;
            this.setBasicAuth(true);
        }
    }

    public synchronized Request authenticateBasic(Response response) throws IOException {
        String headerKey = this.isProxy() ? PROXY_AUTH_RESP : WWW_AUTH_RESP;
        String credential = Credentials.basic((String)this.username, (String)this.password);
        return response.request().newBuilder().header(headerKey, credential).build();
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public boolean isBasicAuth() {
        return this.basicAuth;
    }

    public void setBasicAuth(boolean basicAuth) {
        this.basicAuth = basicAuth;
    }
}

