/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.comparator;

import com.blazebit.comparator.BaseComparator;
import com.blazebit.lang.StringUtils;
import com.blazebit.reflection.ExpressionUtils;
import java.text.Collator;
import java.util.Locale;

public class PropertyPathStringComparator<T>
extends BaseComparator<T> {
    private final Collator collator;
    private final String propertyPath;

    public PropertyPathStringComparator(Locale locale, String propertyPath) {
        if (StringUtils.isEmpty((CharSequence)propertyPath)) {
            throw new IllegalArgumentException("PropertyPath must not be null !!!");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null !!!");
        }
        this.collator = Collator.getInstance(locale);
        this.propertyPath = propertyPath;
    }

    public PropertyPathStringComparator(String propertyPath) {
        this(Locale.getDefault(), propertyPath);
    }

    @Override
    public int compare(T object1, T object2) {
        try {
            Object value2;
            Object value1;
            Integer result = this.compareNullObjects(object1, object2);
            if (result == null && (result = this.compareNullObjects(value1 = ExpressionUtils.getValue(object1, this.propertyPath), value2 = ExpressionUtils.getValue(object2, this.propertyPath))) == null) {
                result = this.collator.compare(value1 instanceof String ? value1 : value1.toString(), value2 instanceof String ? value2 : value2.toString());
            }
            return result;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not compare !!! object1: " + object1.getClass().getName() + " / object2: " + object2.getClass().getName() + " / propertyPath: " + this.propertyPath, e);
        }
    }
}

