/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.lang.ValueAccessor;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class PropertyPathExpression<X, Y>
implements ValueAccessor<X, Y> {
    private final Class<X> source;
    private final boolean allowField;
    private String[] explodedPropertyPath;
    private Method[] getterChain;
    private Field[] fieldChain;
    private Method leafGetter;
    private Method leafSetter;
    private Field leafField;
    private volatile boolean dirty = true;

    public PropertyPathExpression(Class<X> source, String propertyPath) {
        this(source, propertyPath.split("\\."), false);
    }

    public PropertyPathExpression(Class<X> source, String propertyPath, boolean allowFieldAccess) {
        this(source, propertyPath.split("\\."), allowFieldAccess);
    }

    private PropertyPathExpression(Class<X> source, String[] explodedPropertyPath, boolean allowField) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        this.source = source;
        this.explodedPropertyPath = explodedPropertyPath;
        this.allowField = allowField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        if (this.dirty) {
            PropertyPathExpression propertyPathExpression = this;
            synchronized (propertyPathExpression) {
                if (this.dirty) {
                    String[] properties = this.explodedPropertyPath;
                    int getterChainLength = properties.length - 1;
                    ArrayList<Method> getters = new ArrayList<Method>(getterChainLength);
                    ArrayList<Field> fields = new ArrayList<Field>(getterChainLength);
                    Class<Object> current = this.source;
                    if (getterChainLength > 0) {
                        for (int i = 0; i < getterChainLength; ++i) {
                            Method getter = ReflectionUtils.getGetter(current, properties[i]);
                            getters.add(getter);
                            if (getter == null) {
                                if (this.allowField) {
                                    Field field = ReflectionUtils.getField(current, properties[i]);
                                    field.setAccessible(true);
                                    fields.add(field);
                                    current = ReflectionUtils.getResolvedFieldType(current, field);
                                } else {
                                    current = null;
                                }
                            } else {
                                getter.setAccessible(true);
                                fields.add(null);
                                current = ReflectionUtils.getResolvedMethodReturnType(current, getter);
                            }
                            if (current == null) break;
                        }
                    }
                    this.getterChain = getters.toArray(new Method[0]);
                    this.fieldChain = fields.toArray(new Field[0]);
                    if (current != null) {
                        this.leafGetter = ReflectionUtils.getGetter(current, properties[getterChainLength]);
                        this.leafSetter = ReflectionUtils.getSetter(current, properties[getterChainLength]);
                        if (this.leafGetter != null) {
                            this.leafGetter.setAccessible(true);
                        } else if (this.allowField) {
                            this.leafField = ReflectionUtils.getField(current, properties[getterChainLength]);
                            if (this.leafField != null) {
                                this.leafField.setAccessible(true);
                            }
                        }
                        if (this.leafSetter != null) {
                            this.leafSetter.setAccessible(true);
                        }
                    }
                    this.dirty = false;
                }
            }
        }
    }

    @Override
    public final Y getValue(X target) {
        return this.getValue(target, false);
    }

    public final Y getNullSafeValue(X target) {
        return this.getValue(target, true);
    }

    private Y getValue(X target, boolean nullSafe) {
        this.initialize();
        try {
            Method getter;
            Object leafObj = this.getLeafObject(target, nullSafe);
            if (nullSafe && leafObj == null) {
                return null;
            }
            if (this.leafField != null) {
                return (Y)this.leafField.get(leafObj);
            }
            if (this.leafGetter == null && leafObj != null) {
                getter = ReflectionUtils.getGetter(leafObj.getClass(), this.explodedPropertyPath[this.explodedPropertyPath.length - 1]);
                if (getter != null) {
                    getter.setAccessible(true);
                }
            } else {
                getter = this.leafGetter;
            }
            if (getter == null && leafObj != null && this.allowField) {
                Field field = ReflectionUtils.getField(leafObj.getClass(), this.explodedPropertyPath[this.explodedPropertyPath.length - 1]);
                field.setAccessible(true);
                return (Y)field.get(leafObj);
            }
            return (Y)getter.invoke(leafObj, new Object[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public final void setValue(X target, Y value) {
        this.initialize();
        try {
            Object leafObj = this.getLeafObject(target, false);
            if (this.leafField != null) {
                this.leafField.set(leafObj, value);
            } else {
                Method setter;
                if (this.leafSetter == null && leafObj != null) {
                    setter = ReflectionUtils.getSetter(leafObj.getClass(), this.explodedPropertyPath[this.explodedPropertyPath.length - 1]);
                    if (setter != null) {
                        setter.setAccessible(true);
                    }
                } else {
                    setter = this.leafSetter;
                }
                if (setter == null && leafObj != null && this.allowField) {
                    Field f = ReflectionUtils.getField(leafObj.getClass(), this.explodedPropertyPath[this.explodedPropertyPath.length - 1]);
                    f.setAccessible(true);
                    f.set(leafObj, value);
                } else {
                    setter.invoke(leafObj, value);
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object getLeafObject(X target, boolean nullSafe) throws IllegalAccessException, InvocationTargetException {
        int i;
        if (nullSafe && target == null) {
            return null;
        }
        if (target != null && !this.source.isInstance(target)) {
            throw new IllegalArgumentException("Given target is not instance of the source class");
        }
        Object current = target;
        Method[] getters = this.getterChain;
        Field[] fields = this.fieldChain;
        if (getters.length > 0) {
            for (i = 0; i < getters.length; ++i) {
                Method getter = getters[i];
                if (getter == null) {
                    Field field = fields[i];
                    if ((current = field.get(current)) != null) continue;
                    if (nullSafe) {
                        return null;
                    }
                    throw new NullPointerException(field.getName() + " returned null");
                }
                if ((current = getter.invoke(current, new Object[0])) != null) continue;
                if (nullSafe) {
                    return null;
                }
                throw new NullPointerException(getter.getName() + " returned null");
            }
        }
        String[] properties = this.explodedPropertyPath;
        while (i < properties.length - 1) {
            Method getter = ReflectionUtils.getGetter(current.getClass(), properties[i]);
            if (getter == null) {
                if (this.allowField) {
                    Field field = ReflectionUtils.getField(current.getClass(), properties[i]);
                    field.setAccessible(true);
                    current = field.get(current);
                } else {
                    current = null;
                }
            } else {
                getter.setAccessible(true);
                current = getter.invoke(current, new Object[0]);
            }
            if (current == null) {
                if (nullSafe) {
                    return null;
                }
                throw new NullPointerException(properties[i] + " returned null");
            }
            ++i;
        }
        return current;
    }
}

