/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.text;

import com.blazebit.text.BigDecimalFormat;
import com.blazebit.text.BigIntegerFormat;
import com.blazebit.text.BooleanFormat;
import com.blazebit.text.ByteFormat;
import com.blazebit.text.CalendarFormat;
import com.blazebit.text.CharacterFormat;
import com.blazebit.text.ClassFormat;
import com.blazebit.text.CurrencyFormat;
import com.blazebit.text.DateFormat;
import com.blazebit.text.DoubleFormat;
import com.blazebit.text.DurationFormat;
import com.blazebit.text.FloatFormat;
import com.blazebit.text.GregorianCalendarFormat;
import com.blazebit.text.InstantFormat;
import com.blazebit.text.IntegerFormat;
import com.blazebit.text.LocalDateFormat;
import com.blazebit.text.LocalDateTimeFormat;
import com.blazebit.text.LocalTimeFormat;
import com.blazebit.text.LocaleFormat;
import com.blazebit.text.LongFormat;
import com.blazebit.text.MonthDayFormat;
import com.blazebit.text.OffsetDateTimeFormat;
import com.blazebit.text.OffsetTimeFormat;
import com.blazebit.text.ParserContext;
import com.blazebit.text.PeriodFormat;
import com.blazebit.text.SerializableFormat;
import com.blazebit.text.ShortFormat;
import com.blazebit.text.SqlDateFormat;
import com.blazebit.text.StringFormat;
import com.blazebit.text.TimeFormat;
import com.blazebit.text.TimeZoneFormat;
import com.blazebit.text.TimestampFormat;
import com.blazebit.text.URLFormat;
import com.blazebit.text.UUIDFormat;
import com.blazebit.text.YearFormat;
import com.blazebit.text.YearMonthFormat;
import com.blazebit.text.ZoneIdFormat;
import com.blazebit.text.ZoneOffsetFormat;
import com.blazebit.text.ZonedDateTimeFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public final class FormatUtils {
    private static final Map<Class<? extends Serializable>, SerializableFormat<? extends Serializable>> parseableTypes = new HashMap<Class<? extends Serializable>, SerializableFormat<? extends Serializable>>();

    private FormatUtils() {
    }

    public static Map<Class<? extends Serializable>, SerializableFormat<? extends Serializable>> getAvailableFormatters() {
        return Collections.unmodifiableMap(parseableTypes);
    }

    public static boolean isParseableType(Class<?> type) {
        return parseableTypes.containsKey(type) || type.isEnum();
    }

    public static <T extends Serializable> T getParsedValue(Class<T> returnType, String value) throws ParseException {
        return FormatUtils.getParsedValue(returnType, value, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public static <T extends Serializable> T getParsedValue(Class<T> returnType, String value, java.text.DateFormat dateFormat) throws ParseException {
        SerializableFormat<? extends Serializable> formatter = parseableTypes.get(returnType);
        if (formatter == null) {
            if (returnType.isEnum()) {
                return Enum.valueOf(returnType, value);
            }
            throw new IllegalArgumentException("Unknown return type");
        }
        ParserContextImpl ctx = new ParserContextImpl();
        ctx.setAttribute("format", dateFormat);
        return (T)formatter.parse(value, ctx);
    }

    public static <T extends Serializable> String getFormattedValue(Class<T> type, T object) {
        return FormatUtils.getFormattedValue(type, object, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    public static <T extends Serializable> String getFormattedValue(Class<T> type, T object, java.text.DateFormat dateFormat) {
        SerializableFormat<? extends Serializable> formatter = parseableTypes.get(type);
        if (formatter == null) {
            if (object instanceof Enum) {
                return ((Enum)((Object)object)).name();
            }
            throw new IllegalArgumentException("Unknown return type");
        }
        ParserContextImpl ctx = new ParserContextImpl();
        ctx.setAttribute("format", dateFormat);
        return formatter.format(object, ctx);
    }

    static {
        parseableTypes.put(Integer.TYPE, new IntegerFormat());
        parseableTypes.put(Long.TYPE, new LongFormat());
        parseableTypes.put(Double.TYPE, new DoubleFormat());
        parseableTypes.put(Float.TYPE, new FloatFormat());
        parseableTypes.put(Boolean.TYPE, new BooleanFormat());
        parseableTypes.put(Character.TYPE, new CharacterFormat());
        parseableTypes.put(Byte.TYPE, new ByteFormat());
        parseableTypes.put(Short.TYPE, new ShortFormat());
        parseableTypes.put(Integer.class, new IntegerFormat());
        parseableTypes.put(Long.class, new LongFormat());
        parseableTypes.put(Double.class, new DoubleFormat());
        parseableTypes.put(Float.class, new FloatFormat());
        parseableTypes.put(Boolean.class, new BooleanFormat());
        parseableTypes.put(Character.class, new CharacterFormat());
        parseableTypes.put(Byte.class, new ByteFormat());
        parseableTypes.put(Short.class, new ShortFormat());
        parseableTypes.put(String.class, new StringFormat());
        parseableTypes.put(BigInteger.class, new BigIntegerFormat());
        parseableTypes.put(BigDecimal.class, new BigDecimalFormat());
        parseableTypes.put(java.util.Date.class, new DateFormat());
        parseableTypes.put(Date.class, new SqlDateFormat());
        parseableTypes.put(Timestamp.class, new TimestampFormat());
        parseableTypes.put(Time.class, new TimeFormat());
        parseableTypes.put(Calendar.class, new CalendarFormat());
        parseableTypes.put(GregorianCalendar.class, new GregorianCalendarFormat());
        parseableTypes.put(Locale.class, new LocaleFormat());
        parseableTypes.put(TimeZone.class, new TimeZoneFormat());
        parseableTypes.put(Currency.class, new CurrencyFormat());
        parseableTypes.put(Class.class, new ClassFormat());
        parseableTypes.put(UUID.class, new UUIDFormat());
        parseableTypes.put(URL.class, new URLFormat());
        try {
            parseableTypes.put(Class.forName("java.time.Instant"), new InstantFormat());
            parseableTypes.put(Class.forName("java.time.LocalDateTime"), new LocalDateTimeFormat());
            parseableTypes.put(Class.forName("java.time.LocalDate"), new LocalDateFormat());
            parseableTypes.put(Class.forName("java.time.LocalTime"), new LocalTimeFormat());
            parseableTypes.put(Class.forName("java.time.OffsetTime"), new OffsetTimeFormat());
            parseableTypes.put(Class.forName("java.time.OffsetDateTime"), new OffsetDateTimeFormat());
            parseableTypes.put(Class.forName("java.time.ZonedDateTime"), new ZonedDateTimeFormat());
            parseableTypes.put(Class.forName("java.time.Duration"), new DurationFormat());
            parseableTypes.put(Class.forName("java.time.MonthDay"), new MonthDayFormat());
            parseableTypes.put(Class.forName("java.time.Year"), new YearFormat());
            parseableTypes.put(Class.forName("java.time.YearMonth"), new YearMonthFormat());
            parseableTypes.put(Class.forName("java.time.Period"), new PeriodFormat());
            parseableTypes.put(Class.forName("java.time.ZoneId"), new ZoneIdFormat());
            parseableTypes.put(Class.forName("java.time.ZoneOffset"), new ZoneOffsetFormat());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static class ParserContextImpl
    implements ParserContext {
        private final Map<String, Object> contextMap = new HashMap<String, Object>();

        private ParserContextImpl() {
        }

        @Override
        public Object getAttribute(String name) {
            return this.contextMap.get(name);
        }

        public void setAttribute(String name, Object value) {
            this.contextMap.put(name, value);
        }
    }
}

