/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.spi;

import com.blazebit.persistence.spi.FunctionRenderContext;
import java.util.ArrayList;

public class TemplateRenderer {
    private final String[] chunks;
    private final Integer[] parameterIndices;

    public TemplateRenderer(String template) {
        ArrayList<String> chunkList = new ArrayList<String>();
        ArrayList<Integer> parameterIndexList = new ArrayList<Integer>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (c == '?') {
                chunkList.add(sb.toString());
                sb.setLength(0);
                while (++i < template.length()) {
                    c = template.charAt(i);
                    if (Character.isDigit(c)) {
                        sb.append(c);
                        continue;
                    }
                    parameterIndexList.add(Integer.valueOf(sb.toString()) - 1);
                    sb.setLength(0);
                    sb.append(c);
                    break;
                }
                if (i != template.length()) continue;
                parameterIndexList.add(Integer.valueOf(sb.toString()) - 1);
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            chunkList.add(sb.toString());
        }
        this.chunks = chunkList.toArray(new String[chunkList.size()]);
        this.parameterIndices = parameterIndexList.toArray(new Integer[parameterIndexList.size()]);
    }

    public Context start(FunctionRenderContext context) {
        return new Context(this, context);
    }

    public static class Context {
        private final TemplateRenderer template;
        private final FunctionRenderContext context;
        private final Object[] boundValues;
        private int boundValueIndex = 0;

        public Context(TemplateRenderer template, FunctionRenderContext context) {
            this.template = template;
            this.context = context;
            this.boundValues = new Object[template.parameterIndices.length];
        }

        public Context addArgument(int index) {
            if (this.boundValueIndex >= this.boundValues.length) {
                throw new IllegalArgumentException("The index " + this.boundValueIndex + " is invalid since all parameters have already been bound.");
            }
            this.boundValues[this.boundValueIndex++] = index;
            return this;
        }

        public Context addParameter(String chunk) {
            if (this.boundValueIndex >= this.boundValues.length) {
                throw new IllegalArgumentException("The index " + this.boundValueIndex + " is invalid since all parameters have already been bound.");
            }
            this.boundValues[this.boundValueIndex++] = chunk;
            return this;
        }

        public void build() {
            String[] chunks = this.template.chunks;
            Integer[] parameterIndices = this.template.parameterIndices;
            for (int i = 0; i < chunks.length; ++i) {
                this.context.addChunk(chunks[i]);
                if (i >= parameterIndices.length) continue;
                int parameterIndex = parameterIndices[i];
                Object boundValue = this.boundValues[parameterIndex];
                if (boundValue instanceof Integer) {
                    this.context.addArgument((Integer)boundValue);
                    continue;
                }
                this.context.addChunk(boundValue.toString());
            }
        }
    }
}

