/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.BuilderListener;

public class BuilderListenerImpl<T>
implements BuilderListener<T> {
    private T currentBuilder;

    @Override
    public void onReplaceBuilder(T oldBuilder, T newBuilder) {
        if (this.currentBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        if (this.currentBuilder != oldBuilder) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentBuilder = newBuilder;
    }

    public void verifyBuilderEnded() {
        if (this.currentBuilder != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    @Override
    public void onBuilderEnded(T builder) {
        if (this.currentBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.currentBuilder = null;
    }

    @Override
    public void onBuilderStarted(T builder) {
        if (this.currentBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentBuilder = builder;
    }

    @Override
    public boolean isBuilderEnded() {
        return this.currentBuilder == null;
    }
}

