/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.CaseWhenStarterBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.PredicateBuilder;
import com.blazebit.persistence.PredicateOrBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenStarterBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.WhereBuilder;
import com.blazebit.persistence.WhereOrBuilder;
import com.blazebit.persistence.impl.AbstractCommonQueryBuilder;
import com.blazebit.persistence.impl.AbstractManager;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.JoinOnBuilderImpl;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.ResolvingQueryGenerator;
import com.blazebit.persistence.impl.RestrictionBuilderExpressionBuilderListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.CaseExpressionBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.PredicateOrBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RestrictionBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.RightHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.RootPredicate;
import com.blazebit.persistence.impl.builder.predicate.SuperExpressionLeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.transform.ExpressionModifierVisitor;
import com.blazebit.persistence.parser.SimpleQueryGenerator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.modifier.ExpressionModifier;
import com.blazebit.persistence.parser.predicate.CompoundPredicate;
import com.blazebit.persistence.parser.predicate.ExistsPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import java.util.Collections;
import java.util.List;

public abstract class PredicateManager<T extends WhereBuilder<T>>
extends AbstractManager<ExpressionModifier>
implements PredicateBuilder,
WhereBuilder<T> {
    protected final ExpressionFactory expressionFactory;
    protected final RootPredicate rootPredicate;
    private final SubqueryBuilderListenerImpl<?> leftSubqueryPredicateBuilderListener = new LeftHandsideSubqueryPredicateBuilderListener();
    private SubqueryBuilderListenerImpl<?> rightSubqueryPredicateBuilderListener;
    private SubqueryBuilderListenerImpl<?> superExprLeftSubqueryPredicateBuilderListener;
    private CaseExpressionBuilderListener caseExpressionBuilderListener;
    private MultipleSubqueryInitiator<?> currentMultipleSubqueryInitiator;

    PredicateManager(ResolvingQueryGenerator queryGenerator, ParameterManager parameterManager, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory) {
        super(queryGenerator, parameterManager, subqueryInitFactory);
        this.rootPredicate = new RootPredicate(parameterManager, this.getClauseType(), subqueryInitFactory.getQueryBuilder());
        this.expressionFactory = expressionFactory;
    }

    void applyFrom(PredicateManager predicateManager, ExpressionCopyContext copyContext) {
        this.rootPredicate.getPredicate().getChildren().addAll(this.subqueryInitFactory.reattachSubqueries(predicateManager.rootPredicate.getPredicate().copy(copyContext), this.getClauseType()).getChildren());
    }

    <X> RestrictionBuilder<X> restrict(X builder, Expression expr) {
        return (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, expr, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
    }

    <X> CaseWhenStarterBuilder<RestrictionBuilder<X>> restrictCase(X builder) {
        RestrictionBuilderImpl<X> restrictionBuilder = this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(restrictionBuilder);
        return (CaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new CaseWhenBuilderImpl<RestrictionBuilderImpl<X>>(restrictionBuilder, this.caseExpressionBuilderListener, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
    }

    void restrictExpression(Predicate predicate) {
        this.rootPredicate.verifyBuilderEnded();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.getClauseType(), this.subqueryInitFactory.getQueryBuilder());
        List children = this.rootPredicate.getPredicate().getChildren();
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            if (compoundPredicate.getOperator() == CompoundPredicate.BooleanOperator.AND ^ compoundPredicate.isNegated()) {
                children.addAll(compoundPredicate.getChildren());
            } else {
                children.add(predicate);
            }
        } else {
            children.add(predicate);
        }
    }

    void restrictSetExpression(Predicate predicate) {
        this.rootPredicate.verifyBuilderEnded();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.getClauseType(), this.subqueryInitFactory.getQueryBuilder());
        List children = this.rootPredicate.getPredicate().getChildren();
        children.clear();
        if (predicate instanceof CompoundPredicate) {
            CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
            if (compoundPredicate.getOperator() == CompoundPredicate.BooleanOperator.AND ^ compoundPredicate.isNegated()) {
                children.addAll(compoundPredicate.getChildren());
            } else {
                children.add(predicate);
            }
        } else {
            children.add(predicate);
        }
    }

    <X> SimpleCaseWhenStarterBuilder<RestrictionBuilder<X>> restrictSimpleCase(X builder, Expression caseOperand) {
        RestrictionBuilderImpl<X> restrictionBuilder = this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        this.caseExpressionBuilderListener = new CaseExpressionBuilderListener(restrictionBuilder);
        return (SimpleCaseWhenStarterBuilder)this.caseExpressionBuilderListener.startBuilder(new SimpleCaseWhenBuilderImpl<RestrictionBuilderImpl<X>>(restrictionBuilder, this.caseExpressionBuilderListener, this.expressionFactory, caseOperand, this.subqueryInitFactory, this.parameterManager, this.getClauseType()));
    }

    <X> SubqueryInitiator<RestrictionBuilder<X>> restrict(X builder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, this.getClauseType());
    }

    <X> SubqueryBuilder<RestrictionBuilder<X>> restrict(X builder, FullQueryBuilder<?, ?> criteriaBuilder) {
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.leftSubqueryPredicateBuilderListener, false, criteriaBuilder, this.getClauseType());
    }

    <X> MultipleSubqueryInitiator<RestrictionBuilder<X>> restrictSubqueries(X builder, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        RestrictionBuilderImpl<X> restrictionBuilder = this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        MultipleSubqueryInitiatorImpl<RestrictionBuilderImpl<X>> initiator = new MultipleSubqueryInitiatorImpl<RestrictionBuilderImpl<X>>(restrictionBuilder, expr, new RestrictionBuilderExpressionBuilderListener(restrictionBuilder), this.subqueryInitFactory, this.getClauseType());
        return initiator;
    }

    <X> MultipleSubqueryInitiator<X> restrictExpressionSubqueries(X result, Predicate predicate) {
        this.rootPredicate.verifyBuilderEnded();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.getClauseType(), this.subqueryInitFactory.getQueryBuilder());
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(result, (Expression)predicate, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                PredicateManager.this.rootPredicate.getPredicate().getChildren().add((Predicate)builder.getExpression());
                PredicateManager.this.currentMultipleSubqueryInitiator = null;
            }
        }, this.subqueryInitFactory, this.getClauseType());
        this.currentMultipleSubqueryInitiator = initiator;
        return initiator;
    }

    <X> MultipleSubqueryInitiator<X> restrictSetExpressionSubqueries(X result, Predicate predicate, final ExpressionBuilderEndedListener listener) {
        this.rootPredicate.verifyBuilderEnded();
        this.parameterManager.collectParameterRegistrations((Expression)predicate, this.getClauseType(), this.subqueryInitFactory.getQueryBuilder());
        MultipleSubqueryInitiatorImpl<X> initiator = new MultipleSubqueryInitiatorImpl<X>(result, (Expression)predicate, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                List children = PredicateManager.this.rootPredicate.getPredicate().getChildren();
                children.clear();
                children.add((Predicate)builder.getExpression());
                PredicateManager.this.currentMultipleSubqueryInitiator = null;
                if (listener != null) {
                    listener.onBuilderEnded(builder);
                }
            }
        }, this.subqueryInitFactory, this.getClauseType());
        this.currentMultipleSubqueryInitiator = initiator;
        return initiator;
    }

    <X> SubqueryInitiator<RestrictionBuilder<X>> restrict(X builder, String subqueryAlias, String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, expr);
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryInitiator(restrictionBuilder, this.superExprLeftSubqueryPredicateBuilderListener, false, this.getClauseType());
    }

    <X> SubqueryBuilder<RestrictionBuilder<X>> restrict(X builder, String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, true);
        this.superExprLeftSubqueryPredicateBuilderListener = new SuperExpressionLeftHandsideSubqueryPredicateBuilder(subqueryAlias, expr);
        RestrictionBuilder restrictionBuilder = (RestrictionBuilder)this.rootPredicate.startBuilder(new RestrictionBuilderImpl<X>(builder, this.rootPredicate, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.getClauseType()));
        return this.subqueryInitFactory.createSubqueryBuilder(restrictionBuilder, this.superExprLeftSubqueryPredicateBuilderListener, false, criteriaBuilder, this.getClauseType());
    }

    <X> SubqueryInitiator<X> restrictExists(X result) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryInitiator(result, this.rightSubqueryPredicateBuilderListener, true, this.getClauseType());
    }

    <X> SubqueryInitiator<X> restrictNotExists(X result) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryInitiator(result, this.rightSubqueryPredicateBuilderListener, true, this.getClauseType());
    }

    <X> SubqueryBuilder<X> restrictExists(X result, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate()));
        return this.subqueryInitFactory.createSubqueryBuilder(result, this.rightSubqueryPredicateBuilderListener, true, criteriaBuilder, this.getClauseType());
    }

    <X> SubqueryBuilder<X> restrictNotExists(X result, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.rightSubqueryPredicateBuilderListener = this.rootPredicate.startBuilder(new RightHandsideSubqueryPredicateBuilder(this.rootPredicate, (Predicate)new ExistsPredicate(true)));
        return this.subqueryInitFactory.createSubqueryBuilder(result, this.rightSubqueryPredicateBuilderListener, true, criteriaBuilder, this.getClauseType());
    }

    @Override
    public void apply(ExpressionModifierVisitor<? super ExpressionModifier> visitor) {
        visitor.visit(this.rootPredicate, this.getClauseType());
    }

    void verifyBuilderEnded() {
        this.rootPredicate.verifyBuilderEnded();
        this.leftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        if (this.rightSubqueryPredicateBuilderListener != null) {
            this.rightSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.superExprLeftSubqueryPredicateBuilderListener != null) {
            this.superExprLeftSubqueryPredicateBuilderListener.verifySubqueryBuilderEnded();
        }
        if (this.caseExpressionBuilderListener != null) {
            this.caseExpressionBuilderListener.verifyBuilderEnded();
        }
        if (this.currentMultipleSubqueryInitiator != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    void acceptVisitor(Expression.Visitor v) {
        this.rootPredicate.getPredicate().accept(v);
    }

    <X> X acceptVisitor(Expression.ResultVisitor<X> v) {
        return (X)this.rootPredicate.getPredicate().accept(v);
    }

    boolean hasPredicates() {
        return this.rootPredicate.getPredicate().getChildren().size() > 0;
    }

    void buildClause(StringBuilder sb) {
        this.buildClause(sb, Collections.emptyList(), Collections.emptyList());
    }

    void buildClause(StringBuilder sb, List<String> additionalConjuncts, List<String> optionalConjuncts) {
        if (!this.hasPredicates() && additionalConjuncts.isEmpty()) {
            return;
        }
        int initialLength = sb.length();
        sb.append(' ').append(this.getClauseName()).append(' ');
        int oldLength = sb.length();
        this.buildClausePredicate(sb, additionalConjuncts, optionalConjuncts);
        if (sb.length() == oldLength) {
            sb.setLength(initialLength);
        }
    }

    void buildClausePredicate(StringBuilder sb, List<String> additionalConjuncts, List<String> optionalConjuncts) {
        int size = additionalConjuncts.size();
        boolean hasPredicates = size > 0;
        for (int i = 0; i < size; ++i) {
            sb.append(additionalConjuncts.get(i));
            sb.append(" AND ");
        }
        this.queryGenerator.setClauseType(this.getClauseType());
        this.queryGenerator.setQueryBuffer(sb);
        int oldLength = sb.length();
        this.applyPredicate(this.queryGenerator);
        this.queryGenerator.setClauseType(null);
        if (sb.length() == oldLength) {
            if (size > 0) {
                sb.setLength(sb.length() - " AND ".length());
            }
        } else {
            hasPredicates = true;
        }
        if (hasPredicates) {
            for (int i = 0; i < optionalConjuncts.size(); ++i) {
                sb.append(" AND ");
                sb.append(optionalConjuncts.get(i));
            }
        }
    }

    protected abstract String getClauseName();

    void applyPredicate(ResolvingQueryGenerator queryGenerator) {
        SimpleQueryGenerator.BooleanLiteralRenderingContext oldBooleanLiteralRenderingContext = queryGenerator.setBooleanLiteralRenderingContext(SimpleQueryGenerator.BooleanLiteralRenderingContext.PREDICATE);
        queryGenerator.generate((Expression)this.rootPredicate.getPredicate());
        queryGenerator.setBooleanLiteralRenderingContext(oldBooleanLiteralRenderingContext);
    }

    public JoinOnBuilder<?> startOnBuilder(AbstractCommonQueryBuilder<?, ?, ?, ?, ?> builder) {
        return this.rootPredicate.startBuilder(new JoinOnBuilderImpl(builder, this.rootPredicate, this.parameterManager, this.expressionFactory, this.subqueryInitFactory));
    }

    public SubqueryInitiator<RestrictionBuilder<PredicateBuilder>> subquery() {
        return this.restrict(this);
    }

    public SubqueryInitiator<RestrictionBuilder<PredicateBuilder>> subquery(String subqueryAlias, String expression) {
        return this.restrict(this, subqueryAlias, expression);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<PredicateBuilder>> subqueries(String expression) {
        return this.restrictSubqueries(this, expression);
    }

    public SubqueryBuilder<RestrictionBuilder<PredicateBuilder>> subquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrict(this, criteriaBuilder);
    }

    public SubqueryBuilder<RestrictionBuilder<PredicateBuilder>> subquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrict(this, subqueryAlias, expression, criteriaBuilder);
    }

    public PredicateBuilder withExpression(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, false);
        this.restrictExpression(predicate);
        return this;
    }

    public MultipleSubqueryInitiator<PredicateBuilder> withExpressionSubqueries(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, false);
        return this.restrictExpressionSubqueries(this, predicate);
    }

    public RestrictionBuilder<PredicateBuilder> expression(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        return this.restrict(this, expr);
    }

    public CaseWhenStarterBuilder<RestrictionBuilder<PredicateBuilder>> selectCase() {
        return this.restrictCase(this);
    }

    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<PredicateBuilder>> selectCase(String expression) {
        Expression expr = this.expressionFactory.createSimpleExpression(expression, false);
        return this.restrictSimpleCase(this, expr);
    }

    public SubqueryInitiator<PredicateBuilder> exists() {
        return this.restrictExists(this);
    }

    public SubqueryInitiator<PredicateBuilder> notExists() {
        return this.restrictNotExists(this);
    }

    public SubqueryBuilder<PredicateBuilder> exists(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrictExists(this, criteriaBuilder);
    }

    public SubqueryBuilder<PredicateBuilder> notExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.restrictNotExists(this, criteriaBuilder);
    }

    public PredicateOrBuilder<PredicateBuilder> or() {
        return this.rootPredicate.startBuilder(new PredicateOrBuilderImpl<PredicateManager>(this, this.rootPredicate, this.getClauseType(), this.subqueryInitFactory, this.expressionFactory, this.parameterManager));
    }

    public PredicateBuilder setExpression(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, false);
        this.restrictSetExpression(predicate);
        return this;
    }

    public MultipleSubqueryInitiator<PredicateBuilder> setExpressionSubqueries(String expression) {
        Predicate predicate = this.expressionFactory.createBooleanExpression(expression, false);
        return this.restrictSetExpressionSubqueries(this, predicate, null);
    }

    public void verifyEnded() {
        this.rootPredicate.verifyBuilderEnded();
        if (this.currentMultipleSubqueryInitiator != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    public SubqueryInitiator<RestrictionBuilder<T>> whereSubquery() {
        return this.subquery();
    }

    public SubqueryInitiator<RestrictionBuilder<T>> whereSubquery(String subqueryAlias, String expression) {
        return this.subquery(subqueryAlias, expression);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<T>> whereSubqueries(String expression) {
        return this.subqueries(expression);
    }

    public SubqueryBuilder<RestrictionBuilder<T>> whereSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.subquery(criteriaBuilder);
    }

    public SubqueryBuilder<RestrictionBuilder<T>> whereSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.subquery(subqueryAlias, expression, criteriaBuilder);
    }

    public T whereExpression(String expression) {
        return (T)((WhereBuilder)this.withExpression(expression));
    }

    public MultipleSubqueryInitiator<T> whereExpressionSubqueries(String expression) {
        return this.withExpressionSubqueries(expression);
    }

    public RestrictionBuilder<T> where(String expression) {
        return this.expression(expression);
    }

    public CaseWhenStarterBuilder<RestrictionBuilder<T>> whereCase() {
        return this.selectCase();
    }

    public SimpleCaseWhenStarterBuilder<RestrictionBuilder<T>> whereSimpleCase(String expression) {
        return this.selectCase(expression);
    }

    public SubqueryInitiator<T> whereExists() {
        return this.exists();
    }

    public SubqueryInitiator<T> whereNotExists() {
        return this.notExists();
    }

    public SubqueryBuilder<T> whereExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.exists(criteriaBuilder);
    }

    public SubqueryBuilder<T> whereNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.notExists(criteriaBuilder);
    }

    public WhereOrBuilder<T> whereOr() {
        return (WhereOrBuilder)this.or();
    }

    public T setWhereExpression(String expression) {
        this.setExpression(expression);
        return (T)this;
    }

    public MultipleSubqueryInitiator<T> setWhereExpressionSubqueries(String expression) {
        return this.setExpressionSubqueries(expression);
    }

    public PredicateBuilder where() {
        return this;
    }
}

