/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.ObjectBuilder;
import com.blazebit.persistence.SelectBuilder;
import java.lang.reflect.Constructor;
import java.util.List;

public class ClassObjectBuilder<T>
implements ObjectBuilder<T> {
    private final Class<T> clazz;
    private Constructor<T> constructor;

    public ClassObjectBuilder(Class<T> clazz) {
        this.clazz = clazz;
    }

    private Constructor<T> getConstructor(Object[] tuple) {
        Constructor<?>[] constructors = this.clazz.getConstructors();
        Object matchingConstr = null;
        for (Constructor<?> constr : constructors) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            if (paramTypes.length != tuple.length) continue;
            boolean match = true;
            for (int i = 0; i < paramTypes.length; ++i) {
                if (tuple[i] == null || paramTypes[i].isAssignableFrom(tuple[i].getClass())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (matchingConstr != null) {
                throw new RuntimeException("Multiple constructors matching");
            }
            return constr;
        }
        throw new RuntimeException("No matching constructor");
    }

    public T build(Object[] tuple) {
        if (this.constructor == null) {
            this.constructor = this.getConstructor(tuple);
        }
        try {
            return this.constructor.newInstance(tuple);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> buildList(List<T> list) {
        return list;
    }

    public <X extends SelectBuilder<X>> void applySelects(X queryBuilder) {
    }
}

