/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.ReturningObjectBuilder;
import com.blazebit.persistence.SimpleReturningBuilder;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReturningTupleObjectBuilder
implements ReturningObjectBuilder<Tuple> {
    public Tuple build(Object[] tuple) {
        return new TupleImpl(tuple);
    }

    public List<Tuple> buildList(List<Tuple> list) {
        return list;
    }

    public void applyReturning(SimpleReturningBuilder queryBuilder) {
    }

    private class TupleImpl
    implements Tuple {
        private final Object[] tuple;
        private List<TupleElement<?>> tupleElements;

        private TupleImpl(Object[] tuple) {
            this.tuple = tuple;
        }

        public <X> X get(TupleElement<X> tupleElement) {
            return this.get(tupleElement.getAlias(), tupleElement.getJavaType());
        }

        public Object get(String alias) {
            throw new IllegalArgumentException("There were no aliases defined for this result!");
        }

        public <X> X get(String alias, Class<X> type) {
            throw new IllegalArgumentException("There were no aliases defined for this result!");
        }

        public Object get(int i) {
            if (i >= this.tuple.length || i < 0) {
                throw new IllegalArgumentException("Given index [" + i + "] was outside the range of result tuple size [" + this.tuple.length + "] ");
            }
            return this.tuple[i];
        }

        public <X> X get(int i, Class<X> type) {
            return type.cast(this.get(i));
        }

        public Object[] toArray() {
            return (Object[])this.tuple.clone();
        }

        public List<TupleElement<?>> getElements() {
            if (this.tupleElements == null) {
                this.tupleElements = new ArrayList(this.tuple.length);
                for (int i = 0; i < this.tuple.length; ++i) {
                    this.tupleElements.add(new TupleElementImpl(i));
                }
            }
            return this.tupleElements;
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + Arrays.deepHashCode(this.tuple);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TupleImpl other = (TupleImpl)obj;
            return Arrays.deepEquals(this.tuple, other.tuple);
        }

        private class TupleElementImpl<X>
        implements TupleElement<X> {
            private final int index;

            public TupleElementImpl(int index) {
                this.index = index;
            }

            public Class<? extends X> getJavaType() {
                return (Class)TupleImpl.this.tuple[this.index];
            }

            public String getAlias() {
                return null;
            }
        }
    }
}

