/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.BaseFromQueryBuilder;
import com.blazebit.persistence.CaseWhenAndThenBuilder;
import com.blazebit.persistence.CaseWhenBuilder;
import com.blazebit.persistence.CaseWhenOrThenBuilder;
import com.blazebit.persistence.CaseWhenThenBuilder;
import com.blazebit.persistence.CommonQueryBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.FullSelectCTECriteriaBuilder;
import com.blazebit.persistence.LeafOngoingFinalSetOperationSubqueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.QuantifiableBinaryPredicateBuilder;
import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.SimpleCaseWhenBuilder;
import com.blazebit.persistence.StartOngoingSetOperationSubqueryBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryAndExpressionBuilderListener;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInitiatorImpl;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.CaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SimpleCaseWhenBuilderImpl;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.predicate.BinaryExpressionPredicate;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.parser.predicate.PredicateBuilder;
import com.blazebit.persistence.parser.predicate.PredicateQuantifier;
import com.blazebit.persistence.parser.predicate.QuantifiableBinaryExpressionPredicate;
import com.blazebit.persistence.parser.util.TypeUtils;
import jakarta.persistence.metamodel.EntityType;
import java.util.Collection;

public abstract class AbstractQuantifiablePredicateBuilder<T>
extends SubqueryAndExpressionBuilderListener<T>
implements QuantifiableBinaryPredicateBuilder<T>,
PredicateBuilder {
    protected final Expression leftExpression;
    protected final SubqueryInitiatorFactory subqueryInitFactory;
    protected final ExpressionFactory expressionFactory;
    private final T result;
    private final PredicateBuilderEndedListener listener;
    private final boolean wrapNot;
    private Predicate predicate;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private SubqueryInitiatorImpl<T> subqueryInitiator;

    public AbstractQuantifiablePredicateBuilder(T result, PredicateBuilderEndedListener listener, Expression leftExpression, boolean wrapNot, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory, ParameterManager parameterManager, ClauseType clauseType) {
        this.result = result;
        this.listener = listener;
        this.wrapNot = wrapNot;
        this.leftExpression = leftExpression;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.clauseType = clauseType;
    }

    protected abstract QuantifiableBinaryExpressionPredicate createPredicate(Expression var1, Expression var2, PredicateQuantifier var3);

    protected T chain(Predicate predicate) {
        this.verifyBuilderEnded();
        if (this.wrapNot) {
            predicate.negate();
        }
        this.predicate = predicate;
        this.listener.onBuilderEnded(this);
        return this.result;
    }

    protected void chainSubbuilder(Predicate predicate) {
        this.verifyBuilderEnded();
        if (this.wrapNot) {
            predicate.negate();
        }
        this.predicate = predicate;
    }

    public CommonQueryBuilder<?> getParentQueryBuilder() {
        return (CommonQueryBuilder)this.subqueryInitFactory.getQueryBuilder();
    }

    public T value(Object value) {
        return this.chain((Predicate)this.createPredicate(this.leftExpression, (Expression)this.parameterManager.addParameterExpression(value, this.clauseType, this.subqueryInitFactory.getQueryBuilder()), PredicateQuantifier.ONE));
    }

    public T literal(Object value) {
        String literal = TypeUtils.asLiteral((Object)value, (EntityMetamodel)this.subqueryInitFactory.getQueryBuilder().getMetamodel());
        if (literal == null) {
            return this.value(value);
        }
        return this.chain((Predicate)this.createPredicate(this.leftExpression, this.expressionFactory.createInItemExpression(literal), PredicateQuantifier.ONE));
    }

    public T expression(String expression) {
        return this.chain((Predicate)this.createPredicate(this.leftExpression, this.expressionFactory.createSimpleExpression(expression, false), PredicateQuantifier.ONE));
    }

    public MultipleSubqueryInitiator<T> subqueries(String expression) {
        return new MultipleSubqueryInitiatorImpl<T>(this.result, this.expressionFactory.createSimpleExpression(expression, true), new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                AbstractQuantifiablePredicateBuilder.this.chain((Predicate)AbstractQuantifiablePredicateBuilder.this.createPredicate(AbstractQuantifiablePredicateBuilder.this.leftExpression, builder.getExpression(), PredicateQuantifier.ONE));
            }
        }, this.subqueryInitFactory, this.clauseType);
    }

    public RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhen(String expression) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).when(expression);
    }

    public CaseWhenAndThenBuilder<CaseWhenBuilder<T>> caseWhenAnd() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenAnd();
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhenExists() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenExists();
    }

    public SubqueryInitiator<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhenNotExists() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenNotExists();
    }

    public SubqueryBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhenExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenExists(criteriaBuilder);
    }

    public SubqueryBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>> caseWhenNotExists(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenNotExists(criteriaBuilder);
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubquery() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery();
    }

    public SubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubquery(String subqueryAlias, String expression) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery(subqueryAlias, expression);
    }

    public MultipleSubqueryInitiator<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubqueries(String expression) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubqueries(expression);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery(criteriaBuilder);
    }

    public SubqueryBuilder<RestrictionBuilder<CaseWhenThenBuilder<CaseWhenBuilder<T>>>> caseWhenSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenSubquery(subqueryAlias, expression, criteriaBuilder);
    }

    public CaseWhenOrThenBuilder<CaseWhenBuilder<T>> caseWhenOr() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new CaseWhenBuilderImpl<T>(this.result, this, this.subqueryInitFactory, this.expressionFactory, this.parameterManager, this.clauseType)).whenOr();
    }

    public SimpleCaseWhenBuilder<T> simpleCase(String caseOperand) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.startBuilder(new SimpleCaseWhenBuilderImpl<T>(this.result, this, this.expressionFactory, this.expressionFactory.createSimpleExpression(caseOperand, false), this.subqueryInitFactory, this.parameterManager, this.clauseType));
    }

    public SubqueryInitiator<T> all() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ALL));
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this, false, this.clauseType);
    }

    public SubqueryInitiator<T> any() {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ANY));
        return this.subqueryInitFactory.createSubqueryInitiator(this.result, this, false, this.clauseType);
    }

    public SubqueryBuilder<T> all(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ALL));
        return this.subqueryInitFactory.createSubqueryBuilder(this.result, this, false, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<T> any(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ANY));
        return this.subqueryInitFactory.createSubqueryBuilder(this.result, this, false, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<T> one(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.subqueryInitFactory.createSubqueryBuilder(this.result, this, false, criteriaBuilder, this.clauseType);
    }

    public SubqueryBuilder<T> from(Class<?> clazz) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(clazz);
    }

    public SubqueryBuilder<T> from(Class<?> clazz, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(clazz, alias);
    }

    public SubqueryBuilder<T> from(Class<?> clazz, String alias, boolean endResultAsJoinOnBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(clazz, alias, endResultAsJoinOnBuilder);
    }

    public SubqueryBuilder<T> from(EntityType<?> entityType) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(entityType);
    }

    public SubqueryBuilder<T> from(EntityType<?> entityType, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(entityType, alias);
    }

    public SubqueryBuilder<T> from(EntityType<?> entityType, String alias, boolean endResultAsJoinOnBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(entityType, alias, endResultAsJoinOnBuilder);
    }

    public SubqueryBuilder<T> from(String correlationPath) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(correlationPath);
    }

    public SubqueryBuilder<T> from(String correlationPath, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(correlationPath, alias);
    }

    public SubqueryBuilder<T> from(String correlationPath, String alias, boolean endResultAsJoinOnBuilder) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().from(correlationPath, alias, endResultAsJoinOnBuilder);
    }

    public StartOngoingSetOperationSubqueryBuilder<T, LeafOngoingFinalSetOperationSubqueryBuilder<T>> startSet() {
        return this.getSubqueryInitiator().startSet();
    }

    public SubqueryBuilder<T> fromOld(Class<?> entityClass) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromOld(entityClass);
    }

    public SubqueryBuilder<T> fromOld(Class<?> entityClass, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromOld(entityClass, alias);
    }

    public SubqueryBuilder<T> fromNew(Class<?> entityClass) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromNew(entityClass);
    }

    public SubqueryBuilder<T> fromNew(Class<?> entityClass, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromNew(entityClass, alias);
    }

    public SubqueryBuilder<T> fromValues(Class<?> valueClass, String alias, int valueCount) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromValues(valueClass, alias, valueCount);
    }

    public SubqueryBuilder<T> fromValues(Class<?> entityBaseClass, String attributeName, String alias, int valueCount) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromValues(entityBaseClass, attributeName, alias, valueCount);
    }

    public SubqueryBuilder<T> fromIdentifiableValues(Class<?> valueClass, String alias, int valueCount) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromIdentifiableValues(valueClass, alias, valueCount);
    }

    public SubqueryBuilder<T> fromIdentifiableValues(Class<?> valueClass, String identifierAttribute, String alias, int valueCount) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromIdentifiableValues(valueClass, identifierAttribute, alias, valueCount);
    }

    public <X> SubqueryBuilder<T> fromValues(Class<X> valueClass, String alias, Collection<X> values) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromValues(valueClass, alias, values);
    }

    public SubqueryBuilder<T> fromValues(Class<?> entityBaseClass, String attributeName, String alias, Collection<?> values) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromValues(entityBaseClass, attributeName, alias, values);
    }

    public <X> SubqueryBuilder<T> fromIdentifiableValues(Class<X> valueClass, String alias, Collection<X> values) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromIdentifiableValues(valueClass, alias, values);
    }

    public <X> SubqueryBuilder<T> fromIdentifiableValues(Class<X> valueClass, String identifierAttribute, String alias, Collection<X> values) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromIdentifiableValues(valueClass, identifierAttribute, alias, values);
    }

    public FullSelectCTECriteriaBuilder<SubqueryBuilder<T>> fromSubquery(Class<?> cteClass) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromSubquery(cteClass);
    }

    public FullSelectCTECriteriaBuilder<SubqueryBuilder<T>> fromSubquery(Class<?> cteClass, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromSubquery(cteClass, alias);
    }

    public <Z extends BaseFromQueryBuilder<SubqueryBuilder<T>, ? extends Z>> Z fromEntitySubquery(Class<?> cteClass) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromEntitySubquery(cteClass);
    }

    public <Z extends BaseFromQueryBuilder<SubqueryBuilder<T>, ? extends Z>> Z fromEntitySubquery(Class<?> cteClass, String alias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromEntitySubquery(cteClass, alias);
    }

    public <Z extends BaseFromQueryBuilder<SubqueryBuilder<T>, ? extends Z>> Z fromEntitySubquery(Class<?> cteClass, String alias, String subqueryAlias) {
        this.chainSubbuilder((Predicate)this.createPredicate(this.leftExpression, null, PredicateQuantifier.ONE));
        return this.getSubqueryInitiator().fromEntitySubquery(cteClass, alias, subqueryAlias);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        if (!(this.predicate instanceof BinaryExpressionPredicate)) {
            throw new IllegalStateException("SubqueryBuilder ended but predicate type was unexpected");
        }
        ((BinaryExpressionPredicate)this.predicate).setRight((Expression)new SubqueryExpression(builder));
        this.listener.onBuilderEnded(this);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    protected SubqueryInitiatorImpl<T> getSubqueryInitiator() {
        if (this.subqueryInitiator == null) {
            this.subqueryInitiator = this.subqueryInitFactory.createSubqueryInitiator(this.result, this, false, this.clauseType);
        }
        return this.subqueryInitiator;
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        super.onBuilderEnded(builder);
        if (!(this.predicate instanceof BinaryExpressionPredicate)) {
            throw new IllegalStateException("ExpressionBuilder ended but predicate type was unexpected");
        }
        ((BinaryExpressionPredicate)this.predicate).setRight(builder.getExpression());
        this.listener.onBuilderEnded(this);
    }
}

